<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers:username,password,destination");
include("conn.php");
include("functions.php");
$response = array();
$response["status"] = false;
$response["message"] = "Un Authorized";
$headers = getallheaders();
$myUserName =isset($headers["Username"])?$headers["Username"]:$headers["username"];
$myPassword =isset($headers["Password"])?$headers["Password"]:$headers["password"];
$myUserName = mysqli_real_escape_string($conn,$myUserName);
$myPassword =   mysqli_real_escape_string($conn,$myPassword);
$type = $_GET["type"];
if($type=="customerinvoiceline"){
	//delete customer invoice line
	if(isset($_POST["invoiceLine"])){
		$invoiceLine = mysqli_real_escape_string($conn, trim($_POST["invoiceLine"]));
		$checkInvoice = "select * from customerinvoices where invoiceNo = (select invoiceNo from customerinvoicelines where lineId  = '$invoiceLine')";
		//echo $checkInvoice;
		$res = mysqli_query($conn, $checkInvoice);
		if(mysqli_num_rows($res)>0){
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
					$response["message"] ="The invoice has already been deleted and thus the line cannot be deleted";
			}else{
				$sql = "delete from customerinvoicelines where lineId  = '$invoiceLine'";
			$deleteRes = mysqli_query($conn, $sql);
			if($deleteRes){
				if(mysqli_affected_rows($conn)>0){
					$response["status"] = true;
					$response["message"] ="The invoice line was successfully deleted";
				}else{
					$response["status"] = false;
					$response["message"] ="No row was affected by the delete action";
				}
			}else{
					$response["status"] = false;
					$response["message"] ="The invoice line could not be deleted";
			}
			}
			
		}
		}else{
			$response["status"] = true;
			$response["message"] ="The selected invoice line does not exist";
		}
	}
}
else if($type=="vendorinvoiceline"){
	//delete vendor invoice line
	if(isset($_POST["invoiceLine"])){
		$invoiceLine = mysqli_real_escape_string($conn, trim($_POST["invoiceLine"]));
		$checkInvoice = "select * from vendorinvoices where invoiceNo = (select invoiceNo from vendorinvoicelines where lineId  = '$invoiceLine')";
		//echo $checkInvoice;
		$res = mysqli_query($conn, $checkInvoice);
		if(mysqli_num_rows($res)>0){
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
					$response["message"] ="The invoice has already been posted and thus the line cannot be deleted";
			}else{
				$sql = "delete from vendorinvoicelines where lineId  = '$invoiceLine'";
			$deleteRes = mysqli_query($conn, $sql);
			if($deleteRes){
				if(mysqli_affected_rows($conn)>0){
					$response["status"] = true;
					$response["message"] ="The invoice line was successfully deleted";
				}else{
					$response["status"] = false;
					$response["message"] ="No row was affected by the delete action";
				}
			}else{
					$response["status"] = false;
					$response["message"] ="The invoice line could not be deleted";
			}
			}
			
		}
		}else{
			$response["status"] = true;
			$response["message"] ="The selected invoice line does not exist";
		}
	}
}

else if($type=="customerinvoice"){
	//delete customer invoice line
	if(isset($_POST["invoiceNo"])){
		$invoiceNo = mysqli_real_escape_string($conn, trim($_POST["invoiceNo"]));
		$sql = "delete from customerinvoices where invoiceNo  = '$invoiceNo' and posted = 0";
			$res = mysqli_query($conn, $sql);
			if($res){
				if(mysqli_affected_rows($conn)>0){
					$response["status"] = true;
					$response["message"] ="The invoice was successfully deleted";
				}else{
					$response["status"] = false;
					$response["message"] ="No row was affected by the delete action";
				}
			}else{
					$response["status"] = false;
					$response["message"] ="The invoice could not be deleted";
			}
	}
}
else if($type=="vendorinvoice"){
	//delete vendor invoice 
	if(isset($_POST["invoiceNo"])){
		$invoiceNo = mysqli_real_escape_string($conn, trim($_POST["invoiceNo"]));
		$sql = "delete from vendorinvoices where invoiceNo  = '$invoiceNo' and posted = 0";
			$res = mysqli_query($conn, $sql);
			if($res){
				if(mysqli_affected_rows($conn)>0){
					$response["status"] = true;
					$response["message"] ="The invoice was successfully deleted";
				}else{
					$response["status"] = false;
					$response["message"] ="No row was affected by the delete action";
				}
			}else{
					$response["status"] = false;
					$response["message"] ="The invoice could not be deleted";
			}
	}
}

else if($type=="customerreceipt"){
	$receiptNo = mysqli_real_escape_string($conn, trim($_POST["receiptNo"]));
	$sql = "DELETE FROM `customerreceipts` WHERE `receiptNo` ='$receiptNo' and `posted` = 0";
	$res = mysqli_query($conn, $sql);
	if($res){
		if(mysqli_affected_rows($conn)>0){
			$response["status"] = true;
			$response["message"] = "The customer receipt was successfully deleted";
		}else{
		$response["status"] = false;
		$response["message"] = "No record was affected by the delete operation";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "The customer receipt could not be deleted";
	}
	
}

else if($type=="pettycashvouchers"){
	$voucherNo = mysqli_real_escape_string($conn, trim($_POST["voucherNo"]));
	$sql = "DELETE FROM `pettycashvouchers` WHERE `pcvNo` ='$voucherNo' and `posted` = 0";
	$res = mysqli_query($conn, $sql);
	if($res){
		if(mysqli_affected_rows($conn)>0){
			$response["status"] = true;
			$response["message"] = "The petty cash voucher was successfully deleted";
		}else{
		$response["status"] = false;
		$response["message"] = "No record was affected by the delete operation";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "The petty cash voucher could not be deleted";
	}
	
}
else if($type=="pcvlines"){
	/*
	params.put("code", getCode());
            params.put("pcvNo", getPcvNo());
	*/
	$code = trim($_POST["code"]);
	$pcvNo = trim($_POST["pcvNo"]);
	$tPCVNo = mysqli_real_escape_string($conn, $pcvNo);
	$tCode = mysqli_real_escape_string($conn, $code);
	//check pcv exists and posted
	$sql = "SELECT * FROM `pettycashvouchers` where pcvNo  ='$tPCVNo' and posted = 0";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){ //exists and not posted
			$sql = "DELETE FROM `pettycashvoucherlines` WHERE `pcvNo` ='$tPCVNo' and `id` = $tCode";
	$res = mysqli_query($conn, $sql);
	if($res){
		if(mysqli_affected_rows($conn)>0){
			$response["status"] = true;
			$response["message"] = "The petty cash voucher line was successfully deleted";
		}else{
		$response["status"] = false;
		$response["message"] = "No record was affected by the delete operation";
		}
		}else{
			$response["status"] = false;
			$response["message"] = "The petty cash voucher line could not be deleted";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "The petty cash voucher does not exist or has already been posted";
	}
	
	
}
//pcvlines
else if($type=="customer"){
	if(isset($_POST["customerNumber"])){
		$customerNumber = mysqli_real_escape_string($conn, trim($_POST["customerNumber"]));
	//customer does not have any customer ledger entries
	$sql = "SELECT * FROM `customerledgerentries` where CustomerNo = '$customerNumber'";
	$res = mysqli_query($conn, $sql);
	//customer does not have any customer receipt
	$sql1 = "SELECT * FROM `customerreceipts` where customer = '$customerNumber'";
	$res1 = mysqli_query($conn, $sql1);
	//customer does not have any customer invoice
	$sql2 = "SELECT * FROM `customerinvoices` where customer = '$customerNumber'";
	$res2 = mysqli_query($conn, $sql2);
	$error = false;
	$message = "";
	if(mysqli_num_rows($res)>0){
		$message = "The customer has some customer ledger entries and cannot be deleted";
		$error = true;
	}
	if(mysqli_num_rows($res1)>0){
		$message .=strlen($message)>0?"\n":"";
		$message .= "The customer has some customer receipts and cannot be deleted";
		$error = true;
	}
	if(mysqli_num_rows($res2)>0){
		$message .=strlen($message)>0?"\n":"";
		$message .= "The customer has some customer invoices and cannot be deleted";
		$error = true;
	}
	//delete
	if($error){
		$response["status"] = false;
		$response["message"] = $message;
	}else{
	$sql = "DELETE FROM `customers` WHERE `customerNumber` ='$customerNumber'";
	$res = mysqli_query($conn, $sql);
	if($res){
		if(mysqli_affected_rows($conn)>0){
			$response["status"] = true;
			$response["message"] = "The customer was successfully deleted";
		}else{
		$response["status"] = false;
		$response["message"] = "No record was affected by the delete operation";
		}
		}else{
			$response["status"] = false;
			$response["message"] = "The customer could not be deleted";
		}
	
	}
	}
}
//
else if($type=="paymentVoucher"){
	$pvNo = mysqli_real_escape_string($conn, trim($_POST["pvNo"]));
	$sql = "DELETE FROM `paymentvouchers` WHERE `pvNo` ='$pvNo' and `posted` = 0";
	$res = mysqli_query($conn, $sql);
	if($res){
		if(mysqli_affected_rows($conn)>0){
			$response["status"] = true;
			$response["message"] = "The payment voucher was successfully deleted";
		}else{
		$response["status"] = false;
		$response["message"] = "No record was affected by the delete operation";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "The payment voucher could not be deleted";
	}
	
}
else if($type=="loanApplication"){
	//check not issued
	//check no loan ledger entries
	$loanNo = trim($_POST["loanNo"]);
	$tLoanNo  = mysqli_real_escape_string($conn, $loanNo);
	$checkLoan = "SELECT * FROM `loansregister` where LoanNo = '$tLoanNo'";
	$checkRes = mysqli_query($conn, $checkLoan);
	if(mysqli_num_rows($checkRes)==1){
		while($checkResult = mysqli_fetch_assoc($checkRes)){
			if($checkResult["Issued"]){
				$response["status"] = false;
				$response["message"] = "The selected loan has already been issued. It cannot be deleted. ";
			}else{
				$checkLedgers = "SELECT * FROM `loanledgerentries` where LoanNumber = '$tLoanNo'";
				$ledgerRes = mysqli_query($conn, $checkLedgers);
				if(mysqli_num_rows($ledgerRes)>0){
					$response["status"] = false;
					$response["message"] = "The selected loan has already been issued. It cannot be deleted. ";
				}else{
					$delete = "DELETE FROM `loansregister` where LoanNo = ? and `Issued` =0";
					$values = array($loanNo);
					if(pdoExecute($delete, $values)){
						$response["status"] = true;
						$response["message"] = "The loan was successfully deleted ";
					}else{
						$response["status"] = false;
						$response["message"] = "The loan could not be deleted. Please try again. ";
					}
				}
			}
		}
	}else{
		$response["status"] = false;
		$response["message"] = "A loan with the given number does not exist";
	}
}

else if($type=="interestvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn,$voucherNo);
	$sql = "SELECT * FROM `interestvoucher` WHERE voucherNo = '$tVoucherNo' and posted = 0";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)==1){
		$delete = "delete FROM `interestvoucher` WHERE voucherNo = ? and posted = 0";
		$values = array($voucherNo);
		if(pdoExecute($delete, $values)){
			$response["status"] = true;
			$response["message"] = "The interest voucher was successfully deleted";
		}else{
			$response["status"] = false;
			$response["message"] = "The interest voucher could not be deleted. Please try again";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "An Interest Voucher with the given number does not exist or has already been posted";
	}
}
else if($type=="deleteInvestment"){
    
	$investmentNo =  trim($_POST["investmentNumber"]);
	$tInvestmentNo =  mysqli_real_escape_string($conn, $investmentNo);
	$check = "SELECT * FROM `investmentledgerentries` WHERE `investmentNo` = '$tInvestmentNo'";
    $checkres = mysqli_query($conn, $check);
	if(mysqli_num_rows($checkres)>0){
		$response["status"] = false;
		$response["message"] = "The investment has some posted ledger entries. It cannot be deleted";
	}else{
		$sql =  " delete from  investments WHERE `investmentNo` =?";
		$values = array($investmentNo);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "Investment was successfully deleted";			
		}else{
			$response["status"] = false;
			$response["message"] = "Investment could not be deleted";
		}
	}
	
	
}

else if($type=="savingswithdrawal"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	//get details
	//check if posted
	//if not posted, post
	$sql="SELECT * FROM `savingswithdrawal` WHERE `voucherNo` ='$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The withdrawal voucher has already been posted";
			}else{
					
					$sql="delete FROM `savingswithdrawal` WHERE `voucherNo` ='$tVoucherNo'";
					if(mysqli_query($conn, $sql)){
						$response["status"] = true;
						$response["message"] = "The withdrawal voucher was deleted successfully";
					}else{
						$response["status"] = false;
						$response["message"] = "The withdrawal voucher could not be deleted";
					}
			}
		}
	}else{
		$response["status"] = false;
		$response["message"] = "A withdrawal voucher with the given \n  number does not exist";
	}
}
else if($type=="penaltyvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn,$voucherNo);
	$sql = "SELECT * FROM `penaltyvoucher` WHERE voucherNo = '$tVoucherNo' and posted = 0";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)==1){
		$delete = "delete FROM `penaltyvoucher` WHERE voucherNo = ? and posted = 0";
		$values = array($voucherNo);
		if(pdoExecute($delete, $values)){
			$response["status"] = true;
			$response["message"] = "The penalty voucher was successfully deleted";
		}else{
			$response["status"] = false;
			$response["message"] = "The penalty voucher could not be deleted. Please try again";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "An penalty Voucher with the given number does not exist or has already been posted";
	}
}
else if($type=="mobitillvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	$sql = "SELECT * FROM `mobitillvouchers` WHERE voucherNo = '$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	while($result=mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The mobitill voucher has already been posted and cannot be deleted";
		}else{
			$deleteLines = "DELETE FROM `mobitillvoucherlines` WHERE voucherNo = '$tVoucherNo'";
			if(mysqli_query($conn,$deleteLines)){
				$deleteVoucher = "DELETE FROM `mobitillvouchers` WHERE voucherNo = '$tVoucherNo'";
				if(mysqli_query($conn,$deleteVoucher)){
					$response["status"] = true;
					$response["message"] = "The mobitill voucher was successfully deleted";
				}else{
					$response["status"] = false;
					$response["message"] = "The mobitill voucher could not be deleted";
				}
			}else{
				$response["status"] = false;
				$response["message"] = "The mobitill voucher lines could not be deleted";
			}
		}
	}
}
else if($type=="mobitillvoucherlines"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	$sql = "SELECT * FROM `mobitillvouchers` WHERE voucherNo = '$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	while($result=mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The mobitill voucher has already been posted and cannot be deleted";
		}else{
			$deleteLines = "DELETE FROM `mobitillvoucherlines` WHERE voucherNo = '$tVoucherNo'";
			if(mysqli_query($conn,$deleteLines)){
				$response["status"] = true;
				$response["message"] = "The mobitill voucher lines were successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The mobitill voucher lines could not be deleted";
			}
		}
	}
}
else if($type=="transferfunds"){
	$transferNo = trim($_POST["transferNo"]);
	$tTransferNo = mysqli_real_escape_string($conn,$transferNo);
	$check = "SELECT * FROM `transferfunds` WHERE `transferNo` = '$tTransferNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The transfer funds voucher has already been posted";
		}else{
			$sql = "delete from  `transferfunds`   where `transferNo` = ? and  `posted` = ?";
			$values = array($transferNo, 0);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The transfer funds voucher was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The transfer funds voucher could not be deleted";
			}
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A transfer voucher with the given number does not exist";
	}
}
else if($type=="transfervehicle"){
	$transferNo = trim($_POST["transferNo"]);
	$tTransferNo = mysqli_real_escape_string($conn,$transferNo);
	$check = "SELECT * FROM `vehicletransfer` WHERE `transferNo` = '$tTransferNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The vehicle transfer has already been posted";
		}else{
			$sql = "delete from  `vehicletransfer`   where `transferNo` = ? and  `posted` = ?";
			$values = array($transferNo, 0);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The vehicle transfer was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The vehicle transfer could not be deleted";
			}
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A vehicle transfer with the given number does not exist";
	}
}
else if($type=="vehicleexit"){
	$exitNo = trim($_POST["exitNo"]);
	$tExitNo = mysqli_real_escape_string($conn,$exitNo);
	$check = "SELECT * FROM `vehicleexit` WHERE `exitNumber` = '$tExitNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The vehicle exit has already been posted";
		}else{
			$sql = "delete from  `vehicleexit`   where `exitNumber` = ? and  `posted` = ?";
			$values = array($exitNo, 0);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The vehicle exit was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The vehicle exit could not be deleted";
			}
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A vehicle exit with the given number does not exist";
	}
}
else if($type=="badgeapplication"){
	$applicationNo = trim($_POST["applicationNo"]);
	$tApplicationNo = mysqli_real_escape_string($conn,$applicationNo);
	$check = "SELECT * FROM `badgeapplication` WHERE `applicationNo` = '$tApplicationNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["applied"]){
			$response["status"] = false;
			$response["message"] = "The badge application has already been applied and cannot be deleted";
		}else{
			$sql = "DELETE FROM `badgeapplication` WHERE `applicationNo` = ? and  `applied` = ?";
			$values = array($applicationNo, 0);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The badge application was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The badge application could not be deleted";
			}
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A badge application with the given number does not exist";
	}
}
else if($type=="loanrecovered"){
	$recoveryNo = trim($_POST["recoveryNo"]);
	$tRecoveryNo = mysqli_real_escape_string($conn,$recoveryNo);
	$check = "SELECT * FROM `loanrecovery` WHERE `recoveryNo` =  '$tRecoveryNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The loan recovery has already been posted and cannot be deleted";
		}else{
			$sql = "DELETE FROM `loanrecovery` WHERE `recoveryNo` = ? and `posted` = ?";
			$values = array($recoveryNo, 0);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The loan recovery was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The loan recovery could not be deleted";
			}
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A badge application with the given number does not exist";
	}
}
else if($type=="memberexit"){
	$exitNo = trim($_POST["exitNo"]);
	$tExitNo = mysqli_real_escape_string($conn,$exitNo);
	$check = "SELECT * FROM `memberexit` WHERE `exitNumber`  = '$tExitNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The member exit has already been posted";
		}else{
			$sql = "DELETE FROM `memberexit` WHERE `exitNumber` = ? and `posted` = ?";
			$values = array($exitNo, 0);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The member exit was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The member exit could not be deleted";
			}
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A vehicle exit with the given number does not exist";
	}
}
else if($type=="loanproduct"){
	$loanProductCode = trim($_POST["loanProductCode"]);
	$tLoanProductCode = mysqli_real_escape_string($conn,$loanProductCode);
	//check loan product exists, check no of loans issued
	$check = "SELECT A.*, (SELECT COUNT(LoanNo) FROM `loansregister` WHERE LoanProductCode = A.Code and Issued = 1) noOfLoans FROM `loanssetup` A WHERE A.Code = '$tLoanProductCode'";
	$checkRes = mysqli_query($conn, $check);
	$exists = false;
	$noOfLoans = 0;
	while($checkResult = mysqli_fetch_assoc($checkRes)){
		$exists = true;
		$noOfLoans = $checkResult["noOfLoans"];
	}
	if($exists){
		if($noOfLoans>0){
			$response["status"] = false;
			$response["message"] = "Some loans with the selected loan product have already been issued. This loan product cannot be deleted";
		}else{//delete
			$sql = "delete from `loanssetup`  WHERE Code =?";
			$values = array($loanProductCode);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The loan product was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The loan product could not be deleted";
			}
		}
	}else{
		$response["status"] = false;
		$response["message"] = "The given loan product does not exist";
	}
}
else if($type=="banktransfer"){
	$transferNo = trim($_POST["transferNo"]);
	$tTransferNo = mysqli_real_escape_string($conn,$transferNo);
	$check = "SELECT * FROM `banktransfers` WHERE `transferNo`= '$tTransferNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The bank transfer voucher has already been posted";
		}else{
			$sql = "delete from  `banktransfers`   where `transferNo` = ? and  `posted` = ?";
			$values = array($transferNo, 0);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The bank transfer voucher was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The bank transfer voucher could not be deleted";
			}
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A transfer voucher with the given number does not exist";
	}
}
else if($type=="assetacquisition"){
	$acquisitionNo = trim($_POST["acquisitionNo"]);
	$tAcquisitionNo = mysqli_real_escape_string($conn, $acquisitionNo);
	$check = "SELECT * FROM `assetacquisition` WHERE `acquisitionNo` = '$tAcquisitionNo'";
	$res = mysqli_query($conn, $check);
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The asset acquisition has already been posted. It cannot be deleted.";
		}else{
			$sql = "DELETE FROM `assetacquisition` WHERE `acquisitionNo` = ? and posted = ?";
			$values = array($acquisitionNo,0);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The asset acquisition was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The asset acquisition could not be deleted";
			}
		}
	}
}
else if($type=="assetdisposal"){
	$disposalNo = trim($_POST["disposalNo"]);
	$tDisposalNo = mysqli_real_escape_string($conn, $disposalNo);
	$check = "SELECT * FROM `assetdisposal` WHERE `disposalNo` = '$tDisposalNo'";
	$res = mysqli_query($conn, $check);
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The asset disposal has already been posted. It cannot be deleted.";
		}else{
			$sql = "DELETE FROM `assetdisposal` WHERE `disposalNo` = ? and posted = ?";
			$values = array($disposalNo,0);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The asset disposal was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The asset disposal could not be deleted";
			}
		}
	}
}

else if($type=="fixedasset"){
	$assetNo = trim($_POST["assetNo"]);
	$tAssetNo = mysqli_real_escape_string($conn, $assetNo);
	//check no fixed asset ledger entries
	$check = "SELECT * FROM `fixedassetledgerentries` WHERE fixedAssetNo = '$tAssetNo'";
	$res = mysqli_query($conn, $check);
	if(mysqli_num_rows($res)>0){
		$response["status"] = false;
		$response["message"] = "The fixed asset has some ledger entries. It cannot be deleted";
	}else{
		$sql = "DELETE FROM `fixedassets` WHERE faNo = ?";
		$values = array($assetNo);
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The fixed asset was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The fixed asset could not be deleted";
			}
	}
	
}
else if($type=="appreciationdepreciation"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	$check = "SELECT * FROM `appreciation_depreciation` WHERE voucherNo = '$tVoucherNo'";
	$res = mysqli_query($conn, $check);
	if(mysqli_num_rows($res)>0){//exists
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The appreciation/depreciation has already been posted. It cannot be deleted.";
			}else{
				$sql = "DELETE FROM `appreciation_depreciation` WHERE `voucherNo`=? and `posted` = ?";
				$values = array($voucherNo, 0);
				if(pdoExecute($sql,$values)){
					$response["status"] = true;
					$response["message"] = "The appreciation/depreciation voucher was successfully deleted";
				}else{
					$response["status"] = false;
					$response["message"] = "The appreciation/depreciation voucher could not be deleted";
				}
			}
		}
	}else{//non found
		$response["status"] = false;
		$response["message"] = "The appreciation/depreciation voucher does not exist";
	}
}

//salaryvoucher
else if($type=="salaryvoucher"){
	/*
	check if the salary voucher exists
	check if it has not been posted
	*/
	//echo "hi there";
	$voucherNo = mysqli_real_escape_string($conn, trim($_POST['voucherNo']));
	$check = "SELECT * FROM `salaryvouchers` WHERE voucherNo = '$voucherNo'";
	$res = mysqli_query($conn, $check);
	if(mysqli_num_rows($res)>0){//exists
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The salary voucher has already been posted. It cannot be deleted.";
			}else{
				$query = "DELETE FROM `salaryvouchers` WHERE `voucherNo` = ? AND`posted` = ?";
				$values = array($voucherNo, 0);
				if(pdoExecute($query,$values)){
					$response["status"] = true;
					$response["message"] = "The salary voucher was successfully deleted";
				}else{
					$response["status"] = false;
					$response["message"] = "The salary voucher could not be deleted";
				}
			}
			}
	}else{
		$response["status"] = false;
		$response["message"] = "The salary voucher does not exist";
	}
}
else if($type=="vehiclebrands"){
	$brandId = trim($_POST["brandId"]);
	$tBrandId = mysqli_real_escape_string($conn, $brandId);
	$check = "SELECT * FROM `vehicles` WHERE brand = '$tBrandId'";
	$checkres = mysqli_query($conn,$check);
	if(mysqli_num_rows($checkres)>0){ //exists
		$response["status"] = false;
		$response["message"] = "The vehicle brand could not be deleted since it has been linked to some vehicles";
	}else{
		$sql = "DELETE FROM `vehiclebrands` WHERE brandId = ?";
		$values = array($brandId);
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The vehicle brand was successfully deleted";
		}else{
			$response["status"] = false;
			$response["message"] = "The vehicle brand could not be deleted";
		}
	}
	
}
else if($type=="town"){
	$townId = trim($_POST["townId"]);
}else if($type=="servicefeevoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	$sql = "SELECT * FROM `service_fee_vouchers` WHERE id = '$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res )<1){
		$response["status"] = false;
		$response["message"] = "The selected voucher does not exist";
	}else{
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The selected voucher has already been posted";
			}else{
				$delete = "DELETE FROM `service_fee_vouchers` WHERE id = ? AND posted = 0";
				$values = array($voucherNo);
				if(pdoExecute($delete,$values)){
					$response["status"] = true;
					$response["message"] = "The service fee voucher was successfully deleted";
					$deleteLines = "DELETE FROM `service_fee_lines` WHERE voucherNo = ?";
					pdoExecute($deleteLines,$values);
				}else{
					$response["status"] = false;
					$response["message"] = "The service fee voucher could not be deleted";
				}
			}
		}
	}
}
else if($type=="profitnloss"){
	$code = mysqli_real_escape_string($conn, trim($_POST["code"]));
	$sql = "delete from profitnloss where code = '$code'";
	if(mysqli_query($conn, $sql)){
		$sql = "delete from profitnlosslines where profitNLossCode = '$code'";
		mysqli_query($conn, $sql);
		$response["status"] = true;
		$response["message"] = "The profit n loss statement successfully deleted";
	}else{
		$response["status"] = false;
		$response["message"] = "The profit n loss statement could not be deleted";
	}
}
else if($type=="salelines"){
	# 
	$id = $_POST['id'];
	$saleCode = $_POST['saleCode'];
	$sql = "DELETE FROM `expressSaleLines` WHERE `id`=$id";
	$result = mysqli_query($conn, $sql);
	if ($result) {
		$response["status"] = true;
		$response["message"] = "Sale Line has been deleted successfully";
			}else{
		$response["status"] = false;
		$response["message"] = "Unable to delete sale line".mysqli_error($conn);

	}
}
else if($type=="expresssaleline"){
	$id = $_POST['id'];
	$saleCode = $_POST['saleCode'];
	//check sale exists, not posted
	$sql = "DELETE FROM `expresssalelines` WHERE `id`=$id";
	$result = mysqli_query($conn, $sql);
	if ($result) {
		$response["status"] = true;
		$response["message"] = "Sale Line has been deleted successfully";
			}else{
		$response["status"] = false;
		$response["message"] = "Unable to delete sale line".mysqli_error($conn);

	}
}
else if($type=="stocktransferlines"){
	# 
	$id = $_POST['id'];
	$transferCode = $_POST['transferCode'];
	$sql = "DELETE FROM `stockTransferLines` WHERE `id`=$id";
	$result = mysqli_query($conn, $sql);
	if ($result) {
		$response["status"] = true;
		$response["message"] = "Sale Line has been deleted successfully";
		$get = "SELECT A.*, B.name, B.price, B.percentageDiscount FROM `stockTransferLines` A LEFT JOIN `items` B ON A.item=B.code WHERE `transferCode`='$transferCode'";
		$res = mysqli_query($conn, $get);
		$lines = array();
		while ($row2 = mysqli_fetch_assoc($res)) {
			$line = array();
			$line['id']=$row2['id'];
			$line['item']=$row2['item'];
			$line['unitPrice']=$row2['unitPrice'];
			$line['quantity']=$row2['quantity'];
			$line['transferCode']=$row2['transferCode'];
			$item = array();
			$item['code'] = $row2['item'];
			$item['name'] = $row2['name'];
			$item['discount'] = $row2['percentageDiscount'];
			$item['price'] = $row2['price'];
			$line['item'] = $item;
			array_push($lines, $line);
		}
		$response['overLoad1']=json_encode($lines);
	}else{
		$response["status"] = false;
		$response["message"] = "Unable to delete sale line".mysqli_error($conn);

	}
}
elseif ($type=="groupmember") {#`groupMembers` (`id`,`group`,`contact`
	$contact = trim($_POST['contact']);
	$group = trim($_POST['group']);
	$del = "DELETE FROM `groupMembers` WHERE `contact`='$contact' AND `group`='$group' ";
	$result = mysqli_query($conn, $del);
	if ($result) {
		$response["status"] = true;
		$response["message"] = "Contact has been removed from group successfully";
	}else{
		$response["status"] = false;
		$response["message"] = "contact could not be removed from group".mysqli_error($conn);
	}
}
else if($type=="balancesheet"){
	$code = mysqli_real_escape_string($conn, trim($_POST["code"]));
	$sql = "delete from balancesheet where code = '$code'";
	if(mysqli_query($conn, $sql)){
		//$sql = "delete from profitnlosslines where profitNLossCode = '$code'";
		//mysqli_query($conn, $sql);
		$response["status"] = true;
		$response["message"] = "The balance sheet successfully deleted";
	}else{
		$response["status"] = false;
		$response["message"] = "The balance sheet could not be deleted";
	}
}
else if($type=="journal"){
	$journalNo = trim($_POST["journalNo"]);
	$tJournalNo = mysqli_real_escape_string($conn, $journalNo);
	$check = "select * from journal where journalNo = '$tJournalNo'";
	$checkRes = mysqli_query($conn,$check);
	while($result = mysqli_fetch_assoc($checkRes)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The journal has already been posted. No changes can be made.";
		}else{
			$sql = "delete from journal where journalNo = '$tJournalNo'";
			if(mysqli_query($conn, $sql)){
				$sql = "delete from journallines where jounalNo = '$tJournalNo'";
				mysqli_query($conn, $sql);
				$response["status"] = true;
				$response["message"] = "The journal was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The journal could not be deleted";
			}
		}
	}
}
else if($type=="journalline"){
	$lineNo = trim($_POST["lineNo"]);
	$tLineNo = mysqli_real_escape_string($conn, $lineNo);
	$check = "select * from journal where journalNo = (select jounalNo from journallines where lineNo = '$tLineNo')";
	//echo $check;
	$checkRes = mysqli_query($conn,$check);
	while($result = mysqli_fetch_assoc($checkRes)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The journal has already been posted. No changes can be made.";
		}else{
			$sql = "delete from journallines where lineNo = '$tLineNo'";
			if(mysqli_query($conn, $sql)){
				$response["status"] = true;
				$response["message"] = "The journal line was successfully deleted";
			}else{
				$response["status"] = false;
				$response["message"] = "The journal line could not be deleted";
			}
		}
	}
}
elseif ($type=="leaveapplication") {#`leaveApplications`(`id`
	$id = $_POST['id'];
	$del = "DELETE FROM `leaveApplications` WHERE `id`='$id'";
	$result = mysqli_query($conn, $del);
	if ($result) {
		$response["status"] = true;
		$response["message"] = "Application has been deleted successfully";
	}else{
		$response["status"] = false;
		$response["message"] = "Application could be deleted";
	}
}
elseif ($type=="salaryadvance") {#`salaryAdvance`(`id`,
	$id = $_POST['id'];
	$del = "DELETE FROM `salaryAdvance` WHERE `id`='$id' and posted = 0";
	$result = mysqli_query($conn, $del);
	if ($result) {
		$response["status"] = true;
		$response["message"] = "Salary advance has been deleted successfully";
	}else{
		$response["status"] = false;
		$response["message"] = "Salary advance could be deleted";
	}
}elseif ($type=="staffloan") {#`salaryAdvance`(`id`,
	$id = $_POST['id'];
	$del = "DELETE FROM `staffloan` WHERE `id`='$id' and posted = 0";
	$result = mysqli_query($conn, $del);
	if ($result) {
		$response["status"] = true;
		$response["message"] = "Staff loan has been deleted successfully";
	}else{
		$response["status"] = false;
		$response["message"] = "Staff loan could be deleted";
	}
}
elseif ($type=="publicholiday") {# `holidays`(`id`,
	$id = $_POST['id'];
	$del = "DELETE FROM `holidays` WHERE `id`='$id'";
	$result = mysqli_query($conn, $del);
	if ($result) {
		$response["status"] = true;
		$response["message"] = "Holiday has been removed successfully";
	}else{
		$response["status"] = false;
		$response["message"] = "Holiday could be removed";
	}
}
elseif ($type=='leavetype') {
	$id = $_POST['id'];
	$sel = "SELECT * FROM `leaveApplications` WHERE `leaveType` = '$id'";
	$res = mysqli_query($conn, $sel);
	if (mysqli_num_rows($res)>0) {
		$response["status"] = false;
		$response["message"] = "Leave Type is assigned to an application and cannot be removed";
	}else{
		$del = "DELETE FROM `leaveTypes` WHERE `no`='$id'";
		$result = mysqli_query($conn, $del);
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Leave type has been removed successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Leave type  could be removed";
		}
	}
}
elseif ($type=='allowancededuction') {
	$code = mysqli_real_escape_string($conn, trim($_POST["code"]));
	$sel = "SELECT * FROM `allowancesdeductionsmatrix` WHERE `allowanceDeductionCode` = '$code'";
	$res = mysqli_query($conn, $sel);
	$noOfRows = mysqli_num_rows($res);
	$sel = "SELECT * FROM `salaryvoucherlines` WHERE `allowance_deduction_code` = '$code'";
	$res = mysqli_query($conn, $sel);
	$noOfRows += mysqli_num_rows($res);
	if ($noOfRows>0) {
		$response["status"] = false;
		$response["message"] = "The Allowance/Deduction cannot be deleted because it has records attached to it";
	}else{
		$del = "DELETE FROM `allowancesdeductions` WHERE `code`='$code'";
		$result = mysqli_query($conn, $del);
		if ($result) {
			$response["status"] = true;
			$response["message"] = "The allowance/Deduction was successfully deleted";
		}else{
			$response["status"] = false;
			$response["message"] = "The Allowance/Deduction cannot be deleted";
		}
	}
}
else if ($type=="allowancedeductionmatrix") {
	$employeeNo = mysqli_real_escape_string($conn,trim($_POST["employeeNo"]));
	$type = mysqli_real_escape_string($conn,trim($_POST["type"]));
	$code = mysqli_real_escape_string($conn,trim($_POST["code"]));
	$sql = "delete from allowancesdeductionsmatrix where employeeNo= '$employeeNo' and allowanceDeductionCode='$code' and type='$type'";
	if(mysqli_query($conn,$sql)){
		$response["status"] = true;
		$response["message"] = "The allowance or deduction was successfully removed";
	}else{
		$response["status"] = false;
		$response["message"] = "The allowance or deduction could not be removed";
	}
}
else if ($type=="sms") {
	$id = mysqli_real_escape_string($conn,trim($_POST["id"]));
	$check = "select * from sms where id = '$id'";
	$checkRes = mysqli_query($conn, $check);
	if(mysqli_num_rows($checkRes)<1){
		$response["status"] = false;
		$response["message"] = "The selected SMS could not be found";
	}else{
		while($checkResult = mysqli_fetch_assoc($checkRes)){
			if($checkResult["status"]=="sent"){
				$response["status"] = false;
				$response["message"] = "The selected SMS has already been sent. It cannot be deleted";
			}else{
				$sql = "delete from sms where id = '$id' and NOT status = 'sent'";
				if(mysqli_query($conn,$sql)){
					$response["status"] = true;
					$response["message"] = "The selected SMS was successfully deleted";
				}else{
					$response["status"] = false;
					$response["message"] = "The selected SMS could not be deleted";
				}
			}
		}
	}
}
else if ($type=="contact") {
	$contactCode = mysqli_real_escape_string($conn,trim($_POST["contactCode"]));
	$sql = "delete from contacts where id = '$contactCode' ";
	if(mysqli_query($conn,$sql)){
		$response["status"] = true;
		$response["message"] = "The selected Contact was successfully deleted";
	}else{
		$response["status"] = false;
		$response["message"] = "The selected Contact could not be deleted";
	}
}
else if ($type=="contactgroup") {
	$groupCode = mysqli_real_escape_string($conn,trim($_POST["groupCode"]));
	//delete from groupmembers where `group` = 'CGRP001'
	$sql = "delete from groupmembers where `group` = '$groupCode' ";
	if(mysqli_query($conn,$sql)){
		$sql = "delete from groups where `id` = '$groupCode' ";
		if(mysqli_query($conn,$sql)){
			$response["status"] = true;
			$response["message"] = "The selected Group was successfully deleted";
		}else{
			$response["status"] = false;
			$response["message"] = "The selected Group could not be deleted ";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "The selected Group could not be deleted ";
	}
}
else if ($type=="receiptline") {
	$receiptHeader = "";
	if(isset($_POST["receiptLine"])){
		$receiptLine = mysqli_real_escape_string($conn, trim($_POST["receiptLine"]));
		
		$getReceipt = "SELECT * FROM `receiptheader`  where ReceiptNo = (SELECT ReceiptNo FROM `receiptline` where LineNo = '$receiptLine')";
		$posted = true;
		$receiptRes = mysqli_query($conn, $getReceipt);
		while($myReceipt = mysqli_fetch_assoc($receiptRes)){
			$posted  = $myReceipt["Posted"];
			$receiptHeader  = $myReceipt["ReceiptNo"];
		}
		if(!$posted){
		$sql = "delete from receiptline where LineNo = '$receiptLine'";
		if(mysqli_query($conn, $sql)){
			$response["status"] = true;
			$response["message"] ="$receiptHeader";
		}
		}
	}
}
else if ($type=="memberreceipt") {
	if(isset($_POST["receiptNumber"])){
	$receiptNumber = mysqli_real_escape_string($conn, trim($_POST["receiptNumber"]));
	$sql = "delete from receiptheader where ReceiptNo = '$receiptNumber' and Posted = 0";
	if(mysqli_query($conn, $sql)){
		$response["status"] = true;
		$response["message"] ="Receipt was successfully deleted";
	}
}
}
else if ($type=="postinggroup") {
	if(isset($_POST["code"])&&is_numeric($_POST["code"])){
		$code = mysqli_real_escape_string($conn, trim($_POST["code"]));
		//check that no customer, vendor or item is linked to the posting group
		$check = "select Count(customerNumber) noOfCustomers,(select Count(vendorNumber) from vendors where vendorpostinggroup = $code) noOfVendors,(select Count(code) from items where postingGroup = $code) noOfItems from customers where customerpostinggroup = $code";
		$checkRes = mysqli_query($conn,$check);
		$noOfCustomers = 0;
		$noOfVendors = 0;
		$noOfItems = 0;		
		while($checkresult = mysqli_fetch_assoc($checkRes)){
			$noOfCustomers = $checkresult["noOfCustomers"];
			$noOfVendors = $checkresult["noOfVendors"];
			$noOfItems = $checkresult["noOfItems"];	
		}
		$exists = false;
		$message = "";
		if($noOfCustomers>0){
			$message = "The posting group has been linked to some customers";
			$exists = true;
		}
		if($noOfVendors>0){
			$message .= strlen($message)>0?"\n":"";
			$message .= "The posting group has been linked to some vendors";
			$exists = true;
		}if($noOfItems>0){
			$message .= strlen($message)>0?"\n":"";
			$message .= "The posting group has been linked to some items";
			$exists = true;
		}
		if($exists){
			$response["status"] = false;
			$response["message"] =$message;
		}else{
			$sql = "delete from postinggroups where id  = '$code'";
			$res = mysqli_query($conn, $sql);
			if($res){
				if(mysqli_affected_rows($conn)>0){
					$response["status"] = true;
					$response["message"] ="The posting group was successfully deleted";
				}else{
					$response["status"] = false;
					$response["message"] ="No row was affected by the delete action";
				}
			}else{
					$response["status"] = false;
					$response["message"] ="The posting group could not be deleted";
			}	
		}			
		}
}
else if ($type=="member") {
	$memberNumber = $_POST["memberNumber"];
	$checkLedgers = "SELECT * FROM `memberledgerentries` where MemberNo = '$memberNumber'";
	$checkres = mysqli_query($conn,$checkLedgers );
	if(mysqli_num_rows($checkres)>1){
			$response["status"] = false;
		$response["message"] = "Member has some entries in the ledgers and therefore cannot be deleted";
	}else{
	$sql = "DELETE FROM members where MemberNo = ? ";
	$values = array($memberNumber);
	if(pdoExecute($sql,$values)){
	$response["status"] = true;
		$response["message"] = "Member was successfully deleted";	
	}else{
		$response["status"] = false;
		$response["message"] = "Member could not be deleted. Please try again";
	}
	}
}
else if ($type=="chargeitem"){
	if(isset($_POST["code"])&&is_numeric($_POST["code"])){
		$code = mysqli_real_escape_string($conn, trim($_POST["code"]));
			$sql = "delete from chargeitems where id  = '$code'";
			$res = mysqli_query($conn, $sql);
			if($res){
				if(mysqli_affected_rows($conn)>0){
					$response["status"] = true;
					$response["message"] ="The charge item was successfully deleted";
				}else{
					$response["status"] = false;
					$response["message"] ="No row was affected by the delete action";
				}
			}else{
					$response["status"] = false;
					$response["message"] ="The pcharge item could not be deleted";
			}						
		}
}
else if($type=="unitofmeasurerelationship"){
    $id = trim($_POST["id"]);
    $productCode = trim($_POST["productCode"]);
    $unitOfMeasureCode = trim($_POST["unitOfMeasureCode"]);
    $sql = "DELETE FROM `unitofmeasurerelationships` WHERE `id`=? and `productCode`=? and `unitOfMeasureCode` =?";
    $values = array($id,$productCode,$unitOfMeasureCode);
    if(pdoExecute($sql,$values)){
            $response["status"] = true;
			$response["message"] = "The relationship was successfully deleted ";
        }else{
            $response["status"] = false;
			$response["message"] = "The relationship could not be deleted";
        }
    
}
else if ($type=="glaccount"){
	if(isset($_POST["accountNumber"])){
	include("conn.php");	
	$accountNumber = mysqli_real_escape_string($conn, trim($_POST["accountNumber"]));
	if($accountNumber!=""){
	$check = "SELECT * FROM `generalledger` where accountNumber = '$accountNumber' ";
	if(mysqli_num_rows(mysqli_query($conn, $check))>0){
		$response["status"] = false;
		$response["message"] ="The are some posted entries in the general ledger with this account and thus cannot be deleted. ";
	}else{
		$delete = "DELETE FROM `chartofaccounts` WHERE `accountNumber` = '$accountNumber' ";
		if(mysqli_query($conn, $delete)){
			$response["status"] = true;
			$response["message"] ="The g/l account was successfully deleted";
		}else{
			$response["status"] = false;
			$response["message"] ="The account could not be deleted. Please try again later";
		}
	}
	}
}
}

else if($type=="expresssalepayment"){
    if(isset($_POST["headerNo"])&&isset($_POST["documentType"])&&isset($_POST["lineId"])){
        $headerNo = trim($_POST["headerNo"]);
        $itemType = trim($_POST["itemType"]);
        $documentType = trim($_POST["documentType"]);
        $lineId = trim($_POST["lineId"]);
        $docType = fetchWithPdo("SELECT * FROM `document_types` WHERE code= ?",array($documentType));
        if(count($docType)<1){
            $response["status"] = false;
		    $response["message"] ="Unknown Document Type";
        }else{
            $getDocument = fetchWithPdo("SELECT * FROM `sales_header` WHERE doc_no = ? and document_type = ?",array($headerNo,$documentType));
            if(count($getDocument)<1){
                $response["status"] = false;
		        $response["message"] ="The ".$docType[0]["document_type"]." could not be found";
            }else{
                if($getDocument[0]["posted"]){
                    $response["status"] = false;
		            $response["message"] ="The ".$docType[0]["document_type"]." has alredy been posted";
                }else{
                        $sql = "DELETE FROM `express_sale_payments` WHERE `id`=? and `sales_code`=?";
                        $values = array($lineId,$headerNo);
                        if(pdoExecute($sql,$values)){
                            $response["status"] = true;
		                    $response["message"] ="The ".$docType[0]["document_type"]." payment was successfully deleted";
                        }else{
                            $response["status"] = false;
		                    $response["message"] ="The ".$docType[0]["document_type"]." payment could not be deleted";
                        }
                    }
                
            }
        }
    }else{
        $response["status"] = false;
		$response["message"] ="Some mandatory fields could not be found. Please contact Support";
    }
    
    
}
else if($type=="salesline"){
    if(isset($_POST["headerNo"])&&isset($_POST["itemType"])&&isset($_POST["documentType"])&&isset($_POST["lineId"])){
        $headerNo = trim($_POST["headerNo"]);
        $itemType = trim($_POST["itemType"]);
        $documentType = trim($_POST["documentType"]);
        $lineId = trim($_POST["lineId"]);
        $docType = fetchWithPdo("SELECT * FROM `document_types` WHERE code= ?",array($documentType));
        if(count($docType)<1){
            $response["status"] = false;
		    $response["message"] ="Unknown Document Type";
        }else{
            $getDocument = fetchWithPdo("SELECT * FROM `sales_header` WHERE doc_no = ? and document_type = ?",array($headerNo,$documentType));
            if(count($getDocument)<1){
                $response["status"] = false;
		        $response["message"] ="The ".$docType[0]["document_type"]." could not be found";
            }else{
                if($getDocument[0]["posted"]){
                    $response["status"] = false;
		            $response["message"] ="The ".$docType[0]["document_type"]." has alredy been posted";
                }else{
                        $sql = "DELETE FROM `sales_lines` WHERE `lineId`=? and `header_no`=? and `document_type`=?";
                        $values = array($lineId,$headerNo,$documentType);
                        if(pdoExecute($sql,$values)){
                            $response["status"] = true;
		                    $response["message"] ="The ".$docType[0]["document_type"]." line was successfully deleted";
		                    updateInvoiceTotal($headerNo);
                        }else{
                            $response["status"] = false;
		                    $response["message"] ="The ".$docType[0]["document_type"]." line could not be deleted";
                        }
                    }
                
            }
        }
    }else{
        $response["status"] = false;
		$response["message"] ="Some mandatory fields could not be found. Please contact Support";
    }
    
    
}
else if($type=="salespayments"){
    $headerNo = trim($_POST["headerNo"]);
    $paymentMethod = trim($_POST["paymentMethod"]);
    $paymentId = trim($_POST["paymentId"]);
    //confirm header is still pending and not posted;
    $getHeader = fetchWithPdo("SELECT * FROM `sales_header` WHERE doc_no = ?",array($headerNo));
    if(count($getHeader)==1){
        $status = $getHeader[0]["status"];
        if($status=="Draft"){
            $sql = "DELETE FROM `daily_report_payments` WHERE id = ? and report_id=? and payment_method = ?";
            $values= array($paymentId,$headerNo,$paymentMethod);
            if(pdoExecute($sql,$values)){
                $response["status"] = true;
		        $response["message"] ="The payment was successfully deleted";
            }else{
                $response["status"] = false;
		        $response["message"] ="The payment line could not be deleted";
            }
            
        }else{
            $response["status"] = false;
	        $response["message"] ="Status must be pending for you to edit";
        }
    }else{
        $response["status"] = false;
	    $response["message"] ="The header could not be found";
    }
    
    
}



echo json_encode($response);