<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers:username,password,destination");
include("conn.php");
include("functions.php");
$response = array();
$response["status"] = false;
$response["message"] = "Un Authorized";
$headers = getallheaders();
$myUserName =isset($headers["Username"])?$headers["Username"]:$headers["username"];
$myPassword =isset($headers["Password"])?$headers["Password"]:$headers["password"];
$myUserName = mysqli_real_escape_string($conn,$myUserName);
$myPassword =   mysqli_real_escape_string($conn,$myPassword);
$type = $_GET["type"];
if($type=="customerreceipt"){
	$receiptNo = trim($_POST["receiptNo"]);
	$tRNo = mysqli_real_escape_string($conn, $receiptNo);
	//$checkSql = "SELECT A.*, B.`RequiresRef` FROM `customerreceipts` A left join paymentmethods B on A.paymentMethod = B.`Id`  WHERE `receiptNo` = '$tRNo' and `posted` = 0";
	$checkSql = "SELECT A.*, B.`RequiresRef`, SUM(C.total_amount) receiptTotal FROM `customerreceipts` A left join paymentmethods B on A.paymentMethod = B.`Id` left join customer_receipt_lines C on A.receiptNo = C.receipt_no  WHERE `receiptNo` = '$tRNo' and `posted` = 0 Group by A.receiptNo ";
	$checkRes = mysqli_query($conn, $checkSql);
	if(mysqli_num_rows($checkRes)>0){ //exists, unposted
		$error = false;
		$message = "";
		while($receipt = mysqli_fetch_assoc($checkRes)){
			//check customer exists
			if(!customerExists($receipt["customer"])){
				$error = true;
				$message = "Please select the customer making the payment";
			}else{
				$mMessage = customerHasValidPostingGroup($receipt["customer"]);
				if(strlen($mMessage)>0){
					$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= $mMessage;
				}
			}
			//check bank exists
			if(!checkBankExists($receipt["bank"])){
				$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= "Please select the bank receiving the payment";
			}			
			//check payment method exists
			if(!paymentMethodExists($receipt["paymentmethod"])){
				$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= "Please select a payment method";
			}
			//check payment date is valid. more than 1970
			$dateDetails = explode("-", $receipt["paymentDate"]);
			if((($dateDetails[0]+0)<1)||(($dateDetails[1]+0)<1)||(($dateDetails[2]+0)<1)){
				$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= "Please select a valid date when the payment was made";
			}
		
			//check amount is valid greater than 0
			if(!$receipt["receiptTotal"]>0){
				$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= "Please enter a valid amount. It must be greater than zero(0)";
			}
			//if payment method requires Ref
			if($receipt["RequiresRef"]){
				if(trim($receipt["externalRef"])==""){
				$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= "Please enter a payment Ref, Cheque number or external document number";
				}
			}
			//if valid, post 
			if($error){
				$response["status"] = false;
				$response["message"] = $message;
			}else{
				//customer entries
				$items = array();
				$lines ="SELECT * FROM `customer_receipt_lines` WHERE receipt_no = '$tRNo'";
				//echo $lines;
				$linesRes = mysqli_query($conn,$lines);
				while($linesResult = mysqli_fetch_assoc($linesRes)){
					$header = array();
					$header["documentNo"] = $receiptNo;
					$header["externalDocumentno"] = $receipt["externalRef"];
					$header["transactionDate"] = $receipt["paymentDate"];
					$header["transactionType"] = "602";
					$header["description"] ="Payment - ".$receipt["externalRef"];;
					$header["amount"] = $linesResult["total_amount"]*-1;
					$header["accountType"] ="customer";
					$header["accountNumber"] =$receipt["customer"];
					$header["user"] =$myUserName;
					$header["invoiceNo"] = $linesResult["invoice_no"];
					array_push($items,$header);

				}
				
				$customerName = getAccountName("customer",$receipt["customer"]);
				//bank entries
				$line = array();
				$line["documentNo"] = $receiptNo;
				$line["externalDocumentno"] = $receipt["externalRef"];
				$line["transactionDate"] = $receipt["paymentDate"];
				$line["transactionType"] = "601";
				$line["description"] = "Payment from $customerName";//$receipt["beingPaymentFor"];
				$line["amount"] = $receipt["amount"];
				$line["accountNumber"] =$receipt["bank"];
				$line["accountType"] = "bank";
				$line["user"] =$myUserName;
				array_push($items, $line);
				//witholding vat
				if($receipt["withholding_vat"]>0){
					$line = array();
					$line["documentNo"] = $receiptNo;
					$line["externalDocumentno"] = $receipt["externalRef"];
					$line["transactionDate"] = $receipt["paymentDate"];
					$line["transactionType"] = "601";
					$line["description"] = "Witholding VAT from $customerName";//$receipt["beingPaymentFor"];
					$line["amount"] = $receipt["withholding_vat"];
					$line["accountNumber"] =getVATAccount();
					$line["accountType"] = "glaccount";
					$line["user"] =$myUserName;
					array_push($items, $line);
				}
				//withholding income tax
				if($receipt["withholding_income"]>0){
					$line = array();
					$line["documentNo"] = $receiptNo;
					$line["externalDocumentno"] = $receipt["externalRef"];
					$line["transactionDate"] = $receipt["paymentDate"];
					$line["transactionType"] = "601";
					$line["description"] = "Witholding Income Tax from $customerName";//$receipt["beingPaymentFor"];
					$line["amount"] = $receipt["withholding_income"];
					$line["accountNumber"] =getVATAccount();
					$line["accountType"] = "glaccount";
					$line["user"] =$myUserName;
					array_push($items, $line);
				}
				$response = post($items,"customerreceipt", $receiptNo);
			}
			
		}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A receipt with the given receipt number does not exist or is already posted";
	}
}
else if($type=="paymentvoucher"){
	$pvNo = trim($_POST["PVNo"]);
	$tPvNo = mysqli_real_escape_string($conn, $pvNo);
	$checkSql = "SELECT A.*, B.`RequiresRef` FROM `paymentvouchers` A left join paymentmethods B on A.paymentMethod = B.`Id`  WHERE `pvNo` = '$tPvNo ' and `posted` = 0";
	$checkRes = mysqli_query($conn, $checkSql);
	if(mysqli_num_rows($checkRes)>0){ //exists, unposted
		$error = false;
		$message = "";
		while($paymentVoucher = mysqli_fetch_assoc($checkRes)){
			//check customer exists
			
			//check payment date is valid. more than 1970
			$dateDetails = explode("-", $paymentVoucher["paymentDate"]);
			if((($dateDetails[0]+0)<1)||(($dateDetails[1]+0)<1)||(($dateDetails[2]+0)<1)){
				$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= "Please select a valid date when the payment was made";
			}
			
			//check amount is valid greater than 0
			if(!$paymentVoucher["amount"]>0){
				$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= "Please enter a valid amount. It must be greater than zero(0)";
			}
			//if payment method requires Ref
			if($paymentVoucher["RequiresRef"]){
				if(trim($paymentVoucher["externalRef"])==""){
				$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= "Please enter a payment Ref, Cheque number or external document number";
				}
			}
			$salesRep= "";
			//if valid, post 
			if($error){
				$response["status"] = false;
				$response["message"] = $message;
			}else{
			    $items = array();
			    
			    $lines ="SELECT * FROM `payment_voucher_lines` WHERE voucher_no = '$tPvNo'";
				//echo $lines;  
				$linesRes = mysqli_query($conn,$lines);
				while($linesResult = mysqli_fetch_assoc($linesRes)){
					$header = array();
					$header["documentNo"] = $pvNo;
					$header["externalDocumentno"] = $paymentVoucher["externalRef"];
					$header["transactionDate"] = $paymentVoucher["paymentDate"];
					$header["transactionType"] = "pv";
					$header["description"] ="Payment - ".$paymentVoucher["externalRef"];;
					$header["amount"] = $linesResult["total_amount"];
					$header["accountType"] ="vendor";
					$header["accountNumber"] =$paymentVoucher["vendor"];
					$header["user"] =$myUserName;
					$header["invoiceNo"] = $linesResult["invoice_no"];
					$header["region"] =$paymentVoucher["region_code"];
					$header["salesRep"] =$salesRep;
					array_push($items,$header);

				}
				
				$vendorName = getAccountName("vendor",$paymentVoucher["vendor"]);
				//bank entries
				$line = array();
				$line["documentNo"] = $pvNo;
				$line["externalDocumentno"] = $paymentVoucher["externalRef"];
				$line["transactionDate"] = $paymentVoucher["paymentDate"];
				$line["transactionType"] = "pv";
				$line["description"] = "Payment from $vendorName";//$receipt["beingPaymentFor"];
				$line["amount"] = $paymentVoucher["amount"]*-1;
				$line["accountNumber"] =$paymentVoucher["bank"];
				$line["accountType"] = "bank";
				$line["user"] =$myUserName;
				$line["region"] =$paymentVoucher["region_code"];
				$line["salesRep"] =$salesRep;
				array_push($items, $line);
				//witholding vat
				if($paymentVoucher["withholding_vat"]>0){
					$line = array();
					$line["documentNo"] = $pvNo;
					$line["externalDocumentno"] = $paymentVoucher["externalRef"];
					$line["transactionDate"] = $paymentVoucher["paymentDate"];
					$line["transactionType"] = "pv";
					$line["description"] = "Witholding VAT from $vendorName";//$receipt["beingPaymentFor"];
					$line["amount"] = $paymentVoucher["withholding_vat"]*-1;
					$line["accountNumber"] =getVATAccount();
					$line["accountType"] = "glaccount";
					$line["user"] =$myUserName;
					array_push($items, $line);
				}
				//withholding income tax
				if($paymentVoucher["withholding_income"]>0){
					$line = array();
					$line["documentNo"] = $pvNo;
					$line["externalDocumentno"] = $paymentVoucher["externalRef"];
					$line["transactionDate"] = $paymentVoucher["paymentDate"];
					$line["transactionType"] = "pv";
					$line["description"] = "Witholding Income Tax from $vendorName";//$receipt["beingPaymentFor"];
					$line["amount"] = $paymentVoucher["withholding_income"]*-1;
					$line["accountNumber"] =getVATAccount();
					$line["accountType"] = "glaccount";
					$line["user"] =$myUserName;
					array_push($items, $line);
				}
				//print_r($items);
				$response = post($items,"paymentvoucher", $pvNo);
				
				
				//vendor entries
				/*$items = array();
				$header = array();
				$header["documentNo"] = $pvNo;
				$header["externalDocumentno"] = $paymentVoucher["externalRef"];
				$header["transactionDate"] = $paymentVoucher["paymentDate"];
				$header["transactionType"] = "pv";
				$header["description"] = $paymentVoucher["beingPaymentFor"];
				$header["amount"] = $paymentVoucher["amount"];
				$header["accountType"] ="vendor";
				$header["accountNumber"] =$paymentVoucher["vendor"];
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] = $pvNo;
				$line["externalDocumentno"] = $paymentVoucher["externalRef"];
				$line["transactionDate"] = $paymentVoucher["paymentDate"];
				$line["transactionType"] = "pv";
				$line["description"] = $paymentVoucher["beingPaymentFor"];
				$line["amount"] = $paymentVoucher["amount"]*-1;
				$line["accountNumber"] =$paymentVoucher["bank"];
				$line["accountType"] = "bank";
				$line["user"] =$myUserName;
				array_push($items, $line);
				$response = post($items,"paymentvoucher", $pvNo);*/
			}
			
		}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A payment voucher with the given P.V. number does not exist or is already posted";
	}
}
else if($type=="void_payment_voucher"){
	$pvNo = trim($_POST["PVNo"]);
	$tPvNo = mysqli_real_escape_string($conn, $pvNo);
	$checkSql = "SELECT A.*, B.`RequiresRef` FROM `paymentvouchers` A left join paymentmethods B on A.paymentMethod = B.`Id`  WHERE `pvNo` = '$tPvNo ' and `posted` = 1";
	$checkRes = mysqli_query($conn, $checkSql);
	if(mysqli_num_rows($checkRes)>0){ //exists, unposted
		$error = false;
		$message = "";
		while($paymentVoucher = mysqli_fetch_assoc($checkRes)){
			//check customer exists
			
			//check payment date is valid. more than 1970
			$dateDetails = explode("-", $paymentVoucher["paymentDate"]);
			if((($dateDetails[0]+0)<1)||(($dateDetails[1]+0)<1)||(($dateDetails[2]+0)<1)){
				$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= "Please select a valid date when the payment was made";
			}
			
			//check amount is valid greater than 0
			if(!$paymentVoucher["amount"]>0){
				$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= "Please enter a valid amount. It must be greater than zero(0)";
			}
			//if payment method requires Ref
			if($paymentVoucher["RequiresRef"]){
				if(trim($paymentVoucher["externalRef"])==""){
				$error = true;
				$message .= strlen($message)>0?"\n":"";
				$message .= "Please enter a payment Ref, Cheque number or external document number";
				}
			}
			//if valid, post 
			if($error){
				$response["status"] = false;
				$response["message"] = $message;
			}else{
			    $items = array();
			    $salesRep = "";
			    $lines ="SELECT * FROM `payment_voucher_lines` WHERE voucher_no = '$tPvNo'";
				//echo $lines;  
				$linesRes = mysqli_query($conn,$lines);
				while($linesResult = mysqli_fetch_assoc($linesRes)){
					$header = array();
					$header["documentNo"] = $pvNo;
					$header["externalDocumentno"] = $paymentVoucher["externalRef"];
					$header["transactionDate"] = $paymentVoucher["paymentDate"];
					$header["transactionType"] = "pv";
					$header["description"] ="Reverse Payment - ".$paymentVoucher["externalRef"];;
					$header["amount"] = $linesResult["total_amount"]*-1;
					$header["accountType"] ="vendor";
					$header["accountNumber"] =$paymentVoucher["vendor"];
					$header["user"] =$myUserName;
					$header["invoiceNo"] = $linesResult["invoice_no"];
					$header["region"] =$paymentVoucher["region_code"];
				    $header["salesRep"] =$salesRep;
					array_push($items,$header);

				}
				
				$vendorName = getAccountName("vendor",$paymentVoucher["vendor"]);
				//bank entries
				$line = array();
				$line["documentNo"] = $pvNo;
				$line["externalDocumentno"] = $paymentVoucher["externalRef"];
				$line["transactionDate"] = $paymentVoucher["paymentDate"];
				$line["transactionType"] = "pv";
				$line["description"] = "Reverse  Payment from $vendorName";//$receipt["beingPaymentFor"];
				$line["amount"] = $paymentVoucher["amount"];
				$line["accountNumber"] =$paymentVoucher["bank"];
				$line["accountType"] = "bank";
				$line["user"] =$myUserName;
				$line["region"] =$paymentVoucher["region_code"];
				$line["salesRep"] =$salesRep;
				array_push($items, $line);
				//witholding vat
				if($paymentVoucher["withholding_vat"]>0){
					$line = array();
					$line["documentNo"] = $pvNo;
					$line["externalDocumentno"] = $paymentVoucher["externalRef"];
					$line["transactionDate"] = $paymentVoucher["paymentDate"];
					$line["transactionType"] = "pv";
					$line["description"] = "Reverse  Witholding VAT from $vendorName";//$receipt["beingPaymentFor"];
					$line["amount"] = $paymentVoucher["withholding_vat"];
					$line["accountNumber"] ="KSJ062";
					$line["accountType"] = "glaccount";
					$line["user"] =$myUserName;
					array_push($items, $line);
				}
				//withholding income tax
				if($paymentVoucher["withholding_income"]>0){
					$line = array();
					$line["documentNo"] = $pvNo;
					$line["externalDocumentno"] = $paymentVoucher["externalRef"];
					$line["transactionDate"] = $paymentVoucher["paymentDate"];
					$line["transactionType"] = "pv";
					$line["description"] = "Reverse  Witholding Income Tax from $vendorName";//$receipt["beingPaymentFor"];
					$line["amount"] = $paymentVoucher["withholding_income"];
					$line["accountNumber"] ="KSJ062";
					$line["accountType"] = "glaccount";
					$line["user"] =$myUserName;
					array_push($items, $line);
				}
				//print_r($items);
				$response = post($items,"void_payment_voucher", $pvNo);
				
				
				//vendor entries
				/*$items = array();
				$header = array();
				$header["documentNo"] = $pvNo;
				$header["externalDocumentno"] = $paymentVoucher["externalRef"];
				$header["transactionDate"] = $paymentVoucher["paymentDate"];
				$header["transactionType"] = "pv";
				$header["description"] = $paymentVoucher["beingPaymentFor"];
				$header["amount"] = $paymentVoucher["amount"];
				$header["accountType"] ="vendor";
				$header["accountNumber"] =$paymentVoucher["vendor"];
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] = $pvNo;
				$line["externalDocumentno"] = $paymentVoucher["externalRef"];
				$line["transactionDate"] = $paymentVoucher["paymentDate"];
				$line["transactionType"] = "pv";
				$line["description"] = $paymentVoucher["beingPaymentFor"];
				$line["amount"] = $paymentVoucher["amount"]*-1;
				$line["accountNumber"] =$paymentVoucher["bank"];
				$line["accountType"] = "bank";
				$line["user"] =$myUserName;
				array_push($items, $line);
				$response = post($items,"paymentvoucher", $pvNo);*/
			}
			
		}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A payment voucher with the given P.V. number does not exist or is already posted";
	}
}
else if($type=="mobitillvoucher"){
	//check that it exists and that it has not been posted
	//check that it does not have any errors
	//try to post
	$vNo = trim($_POST["vNo"]);
	$tVNo = mysqli_real_escape_string($conn, $vNo);
	$sql = "SELECT *, NOW() currentTime,(select Count(id) from mobitillvoucherlines where voucherNo = '$tVNo') totalLines FROM `mobitillvouchers` where voucherNo ='$tVNo' and posted = 0";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){
		$currentTime = "";
		$error = false;
		while($voucher = mysqli_fetch_assoc($res)){
			$currentTime = $voucher["currentTime"];
			$totalLines = $voucher["totalLines"];
			if($totalLines>2000){
					$response["status"] = false;
					$response["message"] = "The mobitill voucher has too many lines($totalLines). Please reduce the lines to utmost 2,000 lines";
				}else{
			$getLines = "SELECT * FROM `mobitillvoucherlines` where voucherNo = '$tVNo'";
			$linesRes = mysqli_query($conn, $getLines);
			if(mysqli_num_rows($linesRes)>0){
				$total = 0;
				$hasErrors = false;
				$allLines = array();
				//$currentTime = "";
				while($line = mysqli_fetch_assoc($linesRes)){
					
					if($line["hasError"]){//hasError
						$hasErrors = true;
						
						break;
					}else{
						$total +=$line["total"];
						//$types = array(  ,"");  //"" Loan
						$myLine = array();
						if($line["productname"]=="sacco"||$line["productname"]=="sacco arrears"){
							$myLine["documentNo"] = $vNo;
							$myLine["externalDocumentno"] = $line["ticketNo"];
							$myLine["transactionDate"] = $line["timeStamp"]; //
							$myLine["transactionType"] = "202";
							$myLine["description"] = $line["productname"];
							$myLine["amount"] = $line["total"]*-1;
							$myLine["accountType"] ="member";
							$myLine["accountNumber"] =$line["memberNo"];
							$myLine["extra"] =$line["vehicleNo"];
							$myLine["user"] =$myUserName;
						}else if($line["productname"]=="share capital"){
							$myLine["documentNo"] = $vNo;
							$myLine["externalDocumentno"] = $line["ticketNo"];
							$myLine["transactionDate"] = $line["timeStamp"]; //
							$myLine["transactionType"] = "201";
							$myLine["description"] = $line["productname"];
							$myLine["amount"] = $line["total"]*-1;
							$myLine["accountType"] ="member";
							$myLine["accountNumber"] =$line["memberNo"];
							$myLine["extra"] =$line["vehicleNo"];
							$myLine["user"] =$myUserName;
						}//
						else if($line["productname"]=="savings"){
							$myLine["documentNo"] = $vNo;
							$myLine["externalDocumentno"] = $line["ticketNo"];
							$myLine["transactionDate"] = $line["timeStamp"]; //
							$myLine["transactionType"] = "401";
							$myLine["description"] = $line["productname"];
							$myLine["amount"] = $line["total"]*-1;
							$myLine["accountType"] ="member";
							$myLine["accountNumber"] =$line["memberNo"];
							$myLine["extra"] =$line["vehicleNo"];
							$myLine["user"] =$myUserName;
						}else if($line["productname"]=="project"){
							$myLine["documentNo"] = $vNo;
							$myLine["externalDocumentno"] = $line["ticketNo"];
							$myLine["transactionDate"] = $line["timeStamp"]; //
							$myLine["transactionType"] = "PROJ001";
							$myLine["description"] = $line["productname"];
							$myLine["amount"] = $line["total"]*-1;
							$myLine["accountType"] ="member";
							$myLine["accountNumber"] =$line["memberNo"];
							$myLine["extra"] =$line["vehicleNo"];
							$myLine["user"] =$myUserName;
						}
						/*else if($line["productname"]=="LINE MONEY"){
							$myLine["documentNo"] = $vNo;
							$myLine["externalDocumentno"] = $line["ticketNo"];
							$myLine["transactionDate"] = $line["timeStamp"]; //
							$myLine["transactionType"] = "110";
							$myLine["description"] = $line["productname"];
							$myLine["amount"] = $line["total"]*-1;
							$myLine["accountType"] ="member";
							$myLine["accountNumber"] =$line["memberNo"];
							$myLine["user"] =$myUserName;
						}*/
						else if($line["productname"]=="service fee"||$line["productname"]=="service fee arrears"||$line["productname"]=="kce198r"||$line["productname"]=="line money"){
							$myLine["documentNo"] = $vNo;
							$myLine["externalDocumentno"] = $line["ticketNo"];
							$myLine["transactionDate"] = $line["timeStamp"]; //
							$myLine["transactionType"] = "501";
							$myLine["description"] = $line["productname"];
							$myLine["amount"] = $line["total"]*-1;
							$myLine["accountType"] ="vehicle";
							$myLine["accountNumber"] =$line["vehicleNo"];
							$myLine["user"] =$myUserName;
						}
					
						else if($line["productname"]=="limuru"||$line["productname"]=="khoja"||$line["productname"]=="naivasha"||$line["productname"]=="accra"){
							$myLine["documentNo"] = $vNo;
							$myLine["externalDocumentno"] = $line["ticketNo"];
							$myLine["transactionDate"] = $line["timeStamp"]; //
							$myLine["transactionType"] = "501";
							$myLine["description"] = $line["productname"];
							$myLine["amount"] = $line["total"]*-1;
							$myLine["accountType"] ="glaccount";
							$myLine["accountNumber"] ="019";
							$myLine["user"] =$myUserName;
						}
						else if($line["productname"]=="fine"){
							$myLine["documentNo"] = $vNo;
							$myLine["externalDocumentno"] = $line["ticketNo"];
							$myLine["transactionDate"] = $line["timeStamp"]; //
							$myLine["transactionType"] = "801";
							$myLine["description"] = $line["productname"]." ".$line["vehicleNo"];
							$myLine["amount"] = $line["total"]*-1;
							$myLine["accountType"] ="glaccount";
							$myLine["accountNumber"] ="018";
							$myLine["user"] =$myUserName;
						}
						
						else{
							$response["status"] = false;
							$response["message"] = "The selected product name (".$line["productname"].")does not exist";
							$error  = true;
						}
						
						
						array_push($allLines,$myLine);
					}
					
				}
				if($hasErrors){
					$response["status"] = false;
					$response["message"] = "Some of the voucher lines have errors. Please correct ";
				}else{//post
					if(!$error){
						$bankLine = array();
						//10
						$bankLine["documentNo"] = $vNo;
						$bankLine["externalDocumentno"] = "";
						$bankLine["transactionDate"] = $currentTime; //
						$bankLine["transactionType"] = "201";
						$bankLine["description"] = "Mobitill import";
						$bankLine["amount"] = $total;
						$bankLine["accountType"] ="bank";
						$bankLine["accountNumber"] ="10";
						$bankLine["user"] =$myUserName;
						array_push($allLines, $bankLine);
						//echo json_encode($allLines);
						$response = post($allLines, "mobitillvoucher", $vNo);
					}
				}
				
			}else{
				$response["status"] = false;
				$response["message"] = "The voucher does not have any lines. ";
			}
			}
		}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A voucher with the given number does not exist or it has already been posted";
	}
}
else if($type=="loanapplication"){
	if(isset($_POST["loanNumber"])){
		$loanNumber = trim($_POST["loanNumber"]);
		//check loan not issued
		//check that amount is indicated
		//check that bank is selected 
		$tLoanNumber = mysqli_real_escape_string($conn,$loanNumber);
		$check = "SELECT A.*, CalculationMethod, InterestRate FROM `loansregister` A left join loanssetup B on A.LoanProductCode = B.Code WHERE LoanNo = '$tLoanNumber'";
		$checkRes = mysqli_query($conn, $check);
		while($checkResult = mysqli_fetch_assoc($checkRes)){
			if($checkResult["Issued"]){
				$response["status"] = false;
				$response["message"] = "The selected loan has already been issued";
			}else{
				$error = false;
				$message = "";
				if($checkResult["PrincipalAmount"]<1){
					$error = true;
					$message = "Please enter the loan amount";
				}
				if($checkResult["PayingBank"]<1){
					$error = true;
					$message .=strlen($message)>0?"\n":"";
					$message .= "Please select the bank account to issue the loan";
				}
				if($error){
					$response["status"] = false;
					$response["message"] = $message;
				}else{
					$loanAccountNo = $loanNumber;
					$description = "Loan Issuance ".$loanNumber;
					if($checkResult["topUp"]){
						$loanAccountNo = $checkResult["loanTopUpNo"];
						$description = "Loan Top Up ".$loanNumber;
					}
					$currentTime = getCurrentDate();
					$items = array();
					$header = array();
					$header["documentNo"] = $loanNumber;
					$header["externalDocumentno"] = $checkResult["CheckNumber"];
					$header["transactionDate"] = $checkResult["IssuedOn"];
					$header["transactionType"] = "003";
					$header["description"] = $description;
					$header["amount"] = $checkResult["PrincipalAmount"];
					$header["accountType"] ="loan";
					$header["accountNumber"] =$loanAccountNo;
					$header["user"] =$myUserName;
					
					array_push($items,$header);
					$member = $checkResult["MemberNo"];
					$memberName = getMemberName($member);
					//bank entries
					$line = array();
					$line["documentNo"] = $loanNumber;
					$line["externalDocumentno"] = $checkResult["CheckNumber"];
					$line["transactionDate"] = $checkResult["IssuedOn"];
					$line["transactionType"] = "003";
					
					$line["description"] = $memberName." Loan Issuance ".$loanNumber;
					$line["amount"] = $checkResult["PrincipalAmount"]*-1;
					$line["accountNumber"] =$checkResult["PayingBank"];
					$line["accountType"] = "bank";
					$line["user"] =$myUserName;
					array_push($items, $line);
					//charges
					/*$crb = array();
					$crb["documentNo"] = $loanNumber;
					$crb["externalDocumentno"] = $checkResult["chargesexternaldocno"];
					$crb["transactionDate"] = $checkResult["IssuedOn"];
					$crb["transactionType"] = "003";
					$crb["description"] = $memberName." CRB Charge on loan application";
					$crb["amount"] = $checkResult["crbcharge"]*-1;
					$crb["accountNumber"] ="113";
					$crb["accountType"] = "glAccount";
					$crb["user"] =$myUserName;
					array_push($items, $crb);
					
					$chequeComm = array();
					$chequeComm["documentNo"] = $loanNumber;
					$chequeComm["externalDocumentno"] = $checkResult["chargesexternaldocno"];
					$chequeComm["transactionDate"] = $checkResult["IssuedOn"];
					$chequeComm["transactionType"] = "003";
					$chequeComm["description"] = $memberName." Cheque Commission on loan application";
					$chequeComm["amount"] = $checkResult["chequeCommission"]*-1;
					$chequeComm["accountNumber"] ="023";
					$chequeComm["accountType"] = "glAccount";
					$chequeComm["user"] =$myUserName;
					array_push($items, $chequeComm);
					
					$insurance = array();
					$insurance["documentNo"] = $loanNumber;
					$insurance["externalDocumentno"] = $checkResult["chargesexternaldocno"];
					$insurance["transactionDate"] = $checkResult["IssuedOn"];
					$insurance["transactionType"] = "003";
					$insurance["description"] = $memberName." Insurance on loan application";
					$insurance["amount"] = $checkResult["insurance"]*-1;
					$insurance["accountNumber"] ="116";
					$insurance["accountType"] = "glAccount";
					$insurance["user"] =$myUserName;
					array_push($items, $insurance);
					
					$loanForm = array();
					$loanForm["documentNo"] = $loanNumber;
					$loanForm["externalDocumentno"] = $checkResult["chargesexternaldocno"];
					$loanForm["transactionDate"] = $checkResult["IssuedOn"];
					$loanForm["transactionType"] = "003";
					$loanForm["description"] = $memberName." Loan Form on loan application";
					$loanForm["amount"] = $checkResult["loanform"]*-1;
					$loanForm["accountNumber"] ="114";
					$loanForm["accountType"] = "glAccount";
					$loanForm["user"] =$myUserName;
					array_push($items, $loanForm);
					
					$receivingBank = array();
					$receivingBank["documentNo"] = $loanNumber;
					$receivingBank["externalDocumentno"] = $checkResult["chargesexternaldocno"];
					$receivingBank["transactionDate"] = $checkResult["IssuedOn"];
					$receivingBank["transactionType"] = "003";
					$receivingBank["description"] = $memberName." CRB, Cheque Commission, Insurance, Loan Form on loan application";
					$receivingBank["amount"] = $checkResult["crbcharge"]+$checkResult["chequeCommission"]+$checkResult["insurance"]+$checkResult["loanform"];
					$receivingBank["accountNumber"] =$checkResult["chargesreceivingbank"];
					$receivingBank["accountType"] = "bank";
					$receivingBank["user"] =$myUserName;
					array_push($items, $receivingBank);*/
					
					
					
					
					$calculationMethod = $checkResult["CalculationMethod"];
					//if loan calculation method is flat rate, charge interest
					if($calculationMethod=="Flat Rate"){
						$interestRate = $checkResult["InterestRate"];
						$interestAmount = ($interestRate*$checkResult["PrincipalAmount"])/100;
						$interest = array();
						$interest["documentNo"] = "";
						$interest["externalDocumentno"] = "";
						$interest["transactionDate"] = $checkResult["IssuedOn"];
						$interest["transactionType"] = "302";
						$interest["description"] = "Loan $loanNumber Flat rate Interest";
						$interest["amount"] = $interestAmount*-1;
						$interest["accountType"] ="glaccount";
						$interest["accountNumber"] ="003";
						$interest["user"] =$myUserName;
						array_push($items, $interest);
						$loanInterest = array();
						$loanInterest["documentNo"] = "";
						$loanInterest["externalDocumentno"] = "";
						$loanInterest["transactionDate"] = $checkResult["IssuedOn"];
						$loanInterest["transactionType"] = "302";
						$loanInterest["description"] = "Loan $loanNumber Flat rate Interest";
						$loanInterest["amount"] = $interestAmount;
						$loanInterest["accountType"] ="loan";
						$loanInterest["accountNumber"] =$loanAccountNo;
						$loanInterest["user"] =$myUserName;
						array_push($items, $loanInterest);
					}
					
					/*
				
					*/
					
					$response = post($items,"loanapplication", $loanNumber);
				}
			}
		}
	}
}
else if($type=="interestvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn,$voucherNo);
	$sql = "SELECT * FROM `interestvoucher` WHERE voucherNo = '$tVoucherNo' and posted = 0";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)==1){
		if(calculateInterest($voucherNo)){
			$interestLines = "SELECT * FROM `interestlines` WHERE headerNo = '$tVoucherNo'";
			$linesRes = mysqli_query($conn,$interestLines);
			if(mysqli_num_rows($linesRes)>0){
				$date = "";
				while($result = mysqli_fetch_assoc($res)){
					$description = "Interest for the period ".getMonthName($result["month"])." ".$result["year"];
					$year = $result["year"];
					$month = $result["month"];
					$lastDay = "30";
					$oddMonths = array(1,3,5,7,8,10,12);
					if(in_array($month,$oddMonths)){
						$lastDay = "31";
					}
					else if($month ==2){
						$lastDay = "28";
						if(($year%4)==0){
							$lastDay = "29";
						}
					}

					$date= $year."-".$month."-".$lastDay;
					
				}
				
				$items = array();
				$totalInterest = 0;
				while($lineResult = mysqli_fetch_assoc($linesRes)){
					$line = array();
					$line["documentNo"] = $voucherNo;
					$line["externalDocumentno"] = "";
					$line["transactionDate"] = $date;
					$line["transactionType"] = "302";
					$line["description"] = $description;
					$line["amount"] = $lineResult["interest"];
					$line["accountNumber"] =$lineResult["loanNo"];
					$line["accountType"] = "loan";
					$line["user"] =$myUserName;
					$totalInterest+=$lineResult["interest"];
					array_push($items, $line);
				
				}
				$header = array();
				$header["documentNo"] = $voucherNo;
				$header["externalDocumentno"] = "";
				$header["transactionDate"] = $date;
				$header["transactionType"] = "302";
				$header["description"] = $description;
				$header["amount"] = $totalInterest*-1;
				$header["accountType"] ="glaccount";
				$header["accountNumber"] ="003";
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				$response = post($items,"interestvoucher", $voucherNo);
			}else{
				$response["status"] = false;
				$response["message"] = "No interest lines were found in the selected period";
			}
		}else{
			$response["status"] = false;
			$response["message"] = "We could not calculate interest for the selected period. Please try again later";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "An Interest Voucher with the given number does not exist or has already been posted";
	}
}
else if($type=="savingswithdrawalvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	//get details
	//check if posted
	//if not posted, post
	$sql="SELECT * FROM `savingswithdrawal` WHERE `voucherNo` ='$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The withdrawal voucher has already  been posted";
			}else{
				//customer entries
				$items = array();
				$header = array();
				$header["documentNo"] = $voucherNo;
				$header["externalDocumentno"] = $result["chequeNo"];
				$header["transactionDate"] = $result["withdrawalDate"];
				$header["transactionType"] = "401";
				$header["description"] = "Savings withdrawal ".$result["withdrawalPurpose"];
				$header["amount"] = $result["amount"];
				$header["accountType"] ="member";
				$header["accountNumber"] =$result["member"];
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] = $voucherNo;
				$line["externalDocumentno"] = $result["chequeNo"];
				$line["transactionDate"] = $result["withdrawalDate"];
				$line["transactionType"] = "401";
				$line["description"] = getMemberName($result["member"])." ".$result["withdrawalPurpose"]." ".$result["withdrawalDescription"];
				$line["amount"] = $result["amount"]*-1;
				$line["accountNumber"] =$result["bank"];
				$line["accountType"] = "bank";
				$line["user"] =$myUserName;
				array_push($items, $line);
				
				$charges = array();
				$charges["documentNo"] = $voucherNo;
				$charges["externalDocumentno"] = $result["chequeNo"];
				$charges["transactionDate"] = $result["withdrawalDate"];
				$charges["transactionType"] = "401";
				$charges["description"] = "Withdrawal Charges Savings withdrawal";
				$charges["amount"] = $result["withdrawalFee"];
				$charges["accountNumber"] =$result["member"];
				$charges["accountType"] = "member";
				$charges["user"] =$myUserName;
				array_push($items, $charges);
				
				$income = array();
				$income["documentNo"] = $voucherNo;
				$income["externalDocumentno"] = $result["chequeNo"];
				$income["transactionDate"] = $result["withdrawalDate"];
				$income["transactionType"] = "401";
				$income["description"] = "Withdrawal Charges Savings withdrawal";
				$income["amount"] = $result["withdrawalFee"]*-1;
				$income["accountNumber"] ="039";
				$income["accountType"] = "glaccount";
				$income["user"] =$myUserName;
				array_push($items, $income);
				
				$response = post($items,"savingswithdrawalvoucher", $voucherNo);
			}
		}
	}else{
		$response["status"] = false;
		$response["message"] = "A withdrawal voucher with the given \n  number does not exist";
	}
}
else if($type=="reversesavingswithdrawalvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	//get details
	//check if posted
	//if not posted, post
	$sql="SELECT * FROM `savingswithdrawal` WHERE `voucherNo` ='$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){
		while($result = mysqli_fetch_assoc($res)){
			if(!$result["posted"]){
				$response["status"] = false;
				$response["message"] = "The withdrawal voucher  not been posted";
			}else{
				//customer entries
				$items = array();
				$header = array();
				$header["documentNo"] = $voucherNo;
				$header["externalDocumentno"] = $result["chequeNo"];
				$header["transactionDate"] = $result["withdrawalDate"];
				$header["transactionType"] = "401";
				$header["description"] = "Reversal Savings withdrawal ".$result["withdrawalPurpose"];
				$header["amount"] = $result["amount"]*-1;
				$header["accountType"] ="member";
				$header["accountNumber"] =$result["member"];
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] = $voucherNo;
				$line["externalDocumentno"] = $result["chequeNo"];
				$line["transactionDate"] = $result["withdrawalDate"];
				$line["transactionType"] = "401";
				$line["description"] = "Reversal ".getMemberName($result["member"])." ".$result["withdrawalPurpose"]." ".$result["withdrawalDescription"];
				$line["amount"] = $result["amount"];
				$line["accountNumber"] =$result["bank"];
				$line["accountType"] = "bank";
				$line["user"] =$myUserName;
				array_push($items, $line);
				
				$charges = array();
				$charges["documentNo"] = $voucherNo;
				$charges["externalDocumentno"] = $result["chequeNo"];
				$charges["transactionDate"] = $result["withdrawalDate"];
				$charges["transactionType"] = "401";
				$charges["description"] = "Reversal Withdrawal Charges Savings withdrawal";
				$charges["amount"] = $result["withdrawalFee"]*-1;
				$charges["accountNumber"] =$result["member"];
				$charges["accountType"] = "member";
				$charges["user"] =$myUserName;
				array_push($items, $charges);
				
				$income = array();
				$income["documentNo"] = $voucherNo;
				$income["externalDocumentno"] = $result["chequeNo"];
				$income["transactionDate"] = $result["withdrawalDate"];
				$income["transactionType"] = "401";
				$income["description"] = "Reversal Withdrawal Charges Savings withdrawal";
				$income["amount"] = $result["withdrawalFee"];
				$income["accountNumber"] ="039";
				$income["accountType"] = "glaccount";
				$income["user"] =$myUserName;
				array_push($items, $income);
				
				$response = post($items,"reversalsavingswithdrawalvoucher", $voucherNo);
			}
		}
	}else{
		$response["status"] = false;
		$response["message"] = "A withdrawal voucher with the given \n  number does not exist";
	}
}
else if($type=="penaltyvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn,$voucherNo);
	$sql = "SELECT * FROM `penaltyvoucher` WHERE voucherNo = '$tVoucherNo' and posted = 0";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)==1){
		if(calculatePenalty($voucherNo)){
			$penaltylines = "SELECT * FROM `penaltylines` WHERE headerNo = '$tVoucherNo' and exempt = 0";
			$linesRes = mysqli_query($conn,$penaltylines);
			if(mysqli_num_rows($linesRes)>0){
				$date = "";
				while($result = mysqli_fetch_assoc($res)){
					$description = "Penalty for the period ".getMonthName($result["month"])." ".$result["year"];
					$year = $result["year"];
					$month = $result["month"];
					$lastDay = "30";
					$oddMonths = array(1,3,5,7,8,10,12);
					if(in_array($month,$oddMonths)){
						$lastDay = "31";
					}
					else if($month ==2){
						$lastDay = "28";
						if(($year%4)==0){
							$lastDay = "29";
						}
					}

					$date= $year."-".$month."-".$lastDay;
					
				}
				
				$items = array();
				$totalPenalty = 0;
				while($lineResult = mysqli_fetch_assoc($linesRes)){
					$line = array();
					$line["documentNo"] = $voucherNo;
					$line["externalDocumentno"] = "";
					$line["transactionDate"] = $date;
					$line["transactionType"] = "303";
					$line["description"] = $description;
					$line["amount"] = $lineResult["penalty"];
					$line["accountNumber"] =$lineResult["loanNo"];
					$line["accountType"] = "loan";
					$line["user"] =$myUserName;
					$totalPenalty+=$lineResult["penalty"];
					array_push($items, $line);
				
				}
				$header = array();
				$header["documentNo"] = $voucherNo;
				$header["externalDocumentno"] = "";
				$header["transactionDate"] = $date;
				$header["transactionType"] = "303";
				$header["description"] = $description;
				$header["amount"] = $totalPenalty*-1;
				$header["accountType"] ="glaccount";
				$header["accountNumber"] ="004";
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				$response = post($items,"penaltyvoucher", $voucherNo);
			}else{
				$response["status"] = false;
				$response["message"] = "No penalty lines were found in the selected period";
			}
		}else{
			$response["status"] = false;
			$response["message"] = "We could not calculate penalty for the selected period. Please try again later";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "A Penalty Voucher with the given number does not exist or has already been posted";
	}
}
else if($type=="transferfunds"){
	$transferNo = trim($_POST["transferNo"]);
	$tTransferNo = mysqli_real_escape_string($conn,$transferNo);
	$check = "SELECT * FROM `transferfunds` WHERE `transferNo` = '$tTransferNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The transfer funds voucher has already been posted";
		}else{
			// `transferNo`, `transferDate`, `createdOn`, `createdBy`, ``, `fromAccount`, `transferTo`, `toAccount`, ``, `posted`, `postedOn`, `postedBy`, `totalPosted` 
			$memberNo = mysqli_real_escape_string($conn, $result["transferFrom"]);
			$transactionType = mysqli_real_escape_string($conn, $result["fromAccount"]);
			$balance= 0;
			$transferAmount = $result["transferAmount"];
			$sql = "select SUM(Amount) accountBalance from memberledgerentries where MemberNo ='$memberNo' and TransactionType='$transactionType' ";
			$balanceRes = mysqli_query($conn, $sql);
			while($balanceResult = mysqli_fetch_assoc($balanceRes)){
				$balance =  $balanceResult["accountBalance"]*-1;
			}
			if($transferAmount>$balance){
				$response["status"] = false;
				$response["message"] = "The member you want to tranfer from does not have \n sufficient funds in their account. Balance ". number_format($balance,0);
			}else{
				$items = array();
				$header = array();
				$header["documentNo"] = $transferNo;
				$header["externalDocumentno"] = "";
				$header["transactionDate"] = $result["transferDate"];
				$header["transactionType"] = $result["fromAccount"];
				$header["description"] = "Funds Transfer";
				$header["amount"] = $transferAmount;
				$header["accountType"] ="member";
				$header["accountNumber"] =$result["transferFrom"];
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] = $transferNo;
				$line["externalDocumentno"] = "";
				$line["transactionDate"] = $result["transferDate"];
				$line["transactionType"] =$result["toAccount"];
				$line["description"] = "Funds Transfer";
				$line["amount"] = $transferAmount*-1;
				$line["accountNumber"] =$result["transferTo"];
				$line["accountType"] = "member";
				$line["user"] =$myUserName;
				array_push($items, $line);
				$response = post($items,"transferfunds", $transferNo);
			}
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A transfer voucher with the given number does not exist";
	}
}
else if($type=="transfervehicle"){
	$transferNo = trim($_POST["transferNo"]);
	$tTransferNo = mysqli_real_escape_string($conn,$transferNo);
	$check = "SELECT * FROM `vehicletransfer` WHERE `transferNo` = '$tTransferNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The vehicle transfer has already been posted";
		}else{
			$error = false;
			$message = "";
			$pdo = null;
			$conStr = sprintf("mysql:host=%s;dbname=%s", $server, $dbName);
		   try {
           $pdo = new PDO($conStr, $username, $password);
			$pdo->beginTransaction();
			$currentOwner = $result["previousOwner"];
			$newOwner =$result["newOwner"] ;
			$vehicleReg = $result["vehicle"];
			$changeVehicle = "UPDATE `vehicles` SET Owner = ? WHERE RegNo =? AND Owner = ?";
			$stmt1  = $pdo->prepare($changeVehicle);
						$values = array();
						$values[0] = $newOwner;
						$values[1] = $vehicleReg;
						$values[2] = $currentOwner;
						 $stmt1 ->execute($values);            
						if(!$stmt1){
							$error = true;
							$message = "The vehicle transfer could not be posted. Please try again";
							 $pdo->rollBack();
								break;
							
						}
						
				$updateVoucher = "update `vehicletransfer` set posted=1,postedOn = NOW() where transferNo = ?";
					$stmt5  = $pdo->prepare($updateVoucher);
						$values = array();
						$values[0] = $transferNo;
						 $stmt5 ->execute($values);            
						if(!$stmt5){
							$error = true;
							$message = "The vehicle transfer could not be posted. Please try again";
							 $pdo->rollBack();
								break;
							
						}
				if(!$error){		
				
					$pdo->commit();
					$response["status"] = true;
					$response["message"] = "The vehicle transfer was successfully posted";
				}else{
					$response["status"] = false;
					$response["message"] = $message;
				}
			} catch (PDOException $e) {
				$response["status"] = false;
				$response["message"] = "There is an exception".$e->getMessage();
			}
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A vehicle transfer with the given number does not exist";
	}
}
else if($type=="vehicleexit"){
	$exitNo = trim($_POST["exitNo"]);
	$tExitNo = mysqli_real_escape_string($conn,$exitNo);
	$check = "SELECT * FROM `vehicleexit` WHERE `exitNumber` = '$tExitNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The vehicle exit has already been posted";
		}else{
				$vehicle = $result["vehicle"];
				$noObjectionFee = $result["noObjectionFee"];
				$items = array();
				$header = array();
				$header["documentNo"] = $exitNo;
				$header["externalDocumentno"] = "";
				$header["transactionDate"] = $result["exitDate"];
				$header["transactionType"] = "701";
				$header["description"] = "No objection fee of vehicle ".$vehicle;
				$header["amount"] = $noObjectionFee;
				$header["accountType"] ="bank";
				$header["accountNumber"] =$result["receivingBank"];
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] = $exitNo;
				$line["externalDocumentno"] = "";
				$line["transactionDate"] = $result["exitDate"];
				$line["transactionType"] ="701";
				$line["description"] = "No objection fee of vehicle ".$vehicle;
				$line["amount"] = $noObjectionFee*-1;
				$line["accountNumber"] ="020";
				$line["accountType"] = "glaccount";
				$line["user"] =$myUserName;
				array_push($items, $line);
				$response = post($items,"vehicleexit", $exitNo);
			
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A vehicle exit with the given number does not exist";
	}
}
else if($type=="badgeapplication"){
	$applicationNo = trim($_POST["applicationNo"]);
	$tApplicationNo = mysqli_real_escape_string($conn,$applicationNo);
	$check = "SELECT * FROM `badgeapplication` WHERE applicationNo = '$tApplicationNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["applied"]){
			$response["status"] = false;
			$response["message"] = "You have already applied for the given badge";
		}else{
			$error = false;
			$message = "";
			$formApplicationAmount = $result["formApplicationAmount"];
			if($formApplicationAmount>0){
				$bank = $result["formApplicationBank"];
				$externalDocNo = $result["formApplicationExternalDoc"];
				if($bank==0){
					$error = true;
					$message = "Please select the bank receiving the form amount";
				}else{
					$date = getCurrentDate();
					$items = array();
					$header = array();
					$header["documentNo"] = $applicationNo;
					$header["externalDocumentno"] = $externalDocNo;
					$header["transactionDate"] = $date;
					$header["transactionType"] = "801";
					$header["description"] = "Badge Application Form ";
					$header["amount"] = $formApplicationAmount;
					$header["accountType"] ="bank";
					$header["accountNumber"] =$bank;
					$header["user"] =$myUserName;
					
					array_push($items,$header);
					//bank entries
					$line = array();
					$line["documentNo"] = $applicationNo;
					$line["externalDocumentno"] = $externalDocNo;
					$line["transactionDate"] = $date;
					$line["transactionType"] ="801";
					$line["description"] = "Badge Application Form ";
					$line["amount"] = $formApplicationAmount*-1;
					$line["accountNumber"] ="021";
					$line["accountType"] = "glaccount";
					$line["user"] =$myUserName;
					array_push($items, $line);
					$response1 = post($items,"badgeapplication", $applicationNo);
					if(!$response1["status"]){
						$error = true;
						$message = $response1["message"];
					}
				}
			}
			if(!$error){
			$pdo = null;
			$conStr = sprintf("mysql:host=%s;dbname=%s", $server, $dbName);
		   try {
           $pdo = new PDO($conStr, $username, $password);
			$pdo->beginTransaction();
			
			$updateApplication = "UPDATE badgeapplication SET applied = 1, appliedOn = NOW() WHERE applicationNo = ?";
			$stmt1  = $pdo->prepare($updateApplication);
						$values = array();
						$values[0] = $applicationNo;
						 $stmt1 ->execute($values);            
						if(!$stmt1){
							$error = true;
							$message = "The badge application could not be marked as applied. Please try again";
							 $pdo->rollBack();
								break;
							
						}
				if(!$error){		
				
					$pdo->commit();
					$error = false;
					$message = "The badge application was successfully marked as applied";
				}
			} catch (PDOException $e) {
				$error = true;
				$message = "There is an exception".$e->getMessage();
			}
		}
		$response["status"] =!$error;
		$response["message"] = $message;
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A badge application with the given number does not exist";
	}
}
else if($type=="badgereceived"){
	$applicationNo = trim($_POST["applicationNo"]);
	$tApplicationNo = mysqli_real_escape_string($conn,$applicationNo);
	$check = "SELECT A.*,B.phoneNo FROM `badgeapplication` A left join driverconductor B on B.employeeNo = A.employee WHERE applicationNo = '$tApplicationNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists
	while($result = mysqli_fetch_assoc($res)){
		$phoneNo = $result["phoneNo"];
		$error = false;
		$message = "";
		$pdo = null;
			$conStr = sprintf("mysql:host=%s;dbname=%s", $server, $dbName);
		   try {
           $pdo = new PDO($conStr, $username, $password);
			$pdo->beginTransaction();
			
			$updateApplication = "UPDATE badgeapplication SET badgeReceived = 1, receivedOn = NOW() WHERE applicationNo = ?";
			$stmt1  = $pdo->prepare($updateApplication);
						$values = array();
						$values[0] = $applicationNo;
						 $stmt1 ->execute($values);            
						if(!$stmt1){
							$error = true;
							$message = "The badge application could not be marked as received. Please try again";
							 $pdo->rollBack();
								break;
							
						}
				if(!$error){		
				
					$pdo->commit();
					$error = false;
					$message = "The badge application was successfully marked as received";
					$textMessage = "Your PSV Badge is ready for collection at our offices. Kindly make plans to collect it.";
					$phoneNumber = $phoneNo;
					sendTextMessage($phoneNumber, $textMessage);
				}
			} catch (PDOException $e) {
				$error = true;
				$message = "There is an exception".$e->getMessage();
			}
			$response["status"] =!$error;
			$response["message"] = $message;
	}
	}else{
		$response["status"] = false;
		$response["message"] = "A badge application with the given number does not exist";
	}
}
else if($type=="badgecollected"){
	$applicationNo = trim($_POST["applicationNo"]);
	$tApplicationNo = mysqli_real_escape_string($conn,$applicationNo);
	$check = "SELECT * FROM `badgeapplication` WHERE applicationNo = '$tApplicationNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists
	while($result = mysqli_fetch_assoc($res)){
		$badgeCollectionAmount = $result["badgeCollectionAmount"];
			if($badgeCollectionAmount>0){
				$bank = $result["badgeCollectionBank"];
				$externalDocNo = $result["badgeCollectionExternalDoc"];
				if($bank==0){
					$response["status"] = false;
					$response["message"] = "Please select the bank receiving the badge collection amount";
				}else{
					$date = getCurrentDate();
					$items = array();
					$header = array();
					$header["documentNo"] = $applicationNo;
					$header["externalDocumentno"] = $externalDocNo;
					$header["transactionDate"] = $date;
					$header["transactionType"] = "802";
					$header["description"] = "Badge Collection ";
					$header["amount"] = $badgeCollectionAmount;
					$header["accountType"] ="bank";
					$header["accountNumber"] =$bank;
					$header["user"] =$myUserName;
					
					array_push($items,$header);
					//bank entries
					$line = array();
					$line["documentNo"] = $applicationNo;
					$line["externalDocumentno"] = $externalDocNo;
					$line["transactionDate"] = $date;
					$line["transactionType"] ="802";
					$line["description"] = "Badge Collection";
					$line["amount"] = $badgeCollectionAmount*-1;
					$line["accountNumber"] ="022";
					$line["accountType"] = "glaccount";
					$line["user"] =$myUserName;
					array_push($items, $line);
					$response = post($items,"badgecollection", $applicationNo);
					
				}
			}else{
				$response["status"] = false;
				$response["message"] = "Kindly update the amount the employee has paid as badge collection amount";
			}
		   
		
	}
	}else{
		$response["status"] = false;
		$response["message"] = "A badge application with the given number does not exist";
	}
}
else if($type=="recoverloan"){
	$recoveryNo = trim($_POST["recoveryNo"]);
	$tRecoveryNo = mysqli_real_escape_string($conn,$recoveryNo);
	$check = "SELECT * FROM `loanrecovery` WHERE `recoveryNo` =  '$tRecoveryNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The loan recovery has already been posted";
		}else{
			$balancingCharge = $result["balancingCharge"];
			$amountFromContributions = $result["amountFromContributions"];
			$loanRepayment = $amountFromContributions - $balancingCharge;
				$items = array();
				$header = array();
				$header["documentNo"] = $recoveryNo;
				$header["externalDocumentno"] = "";
				$header["transactionDate"] = $result["recoveryDate"];
				$header["transactionType"] = "202";
				$header["description"] = "Loan Recovery ".$result["loan"];
				$header["amount"] = $result["amountFromContributions"];
				$header["accountType"] ="member";
				$header["accountNumber"] =$result["member"];
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] =$recoveryNo;
				$line["externalDocumentno"] = "";
				$line["transactionDate"] = $result["recoveryDate"];
				$line["transactionType"] ="307";
				$line["description"] = "Loan Recovery From Contributions";
				$line["amount"] = $loanRepayment*-1;
				$line["accountNumber"] =$result["loan"];
				$line["accountType"] = "loan";
				$line["user"] =$myUserName;
				array_push($items, $line);
				
				$charge = array();
				$charge["documentNo"] =$recoveryNo;
				$charge["externalDocumentno"] = "";
				$charge["transactionDate"] = $result["recoveryDate"];
				$charge["transactionType"] ="307";
				$charge["description"] = "Balancing Charge for Loan".$result["loan"];
				$charge["amount"] = $balancingCharge*-1;
				$charge["accountNumber"] ="007";
				$charge["accountType"] = "glaccount";
				$charge["user"] =$myUserName;
				array_push($items, $charge);
				$response = post($items,"recoverloan", $recoveryNo);
			
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A transfer voucher with the given number does not exist";
	}
}
else if($type=="memberexit"){
	$exitNo = trim($_POST["exitNo"]);
	$tExitNo = mysqli_real_escape_string($conn,$exitNo);
	$check = "SELECT * FROM `memberexit` WHERE `exitNumber` = '$tExitNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The member exit has already been posted";
		}else{
				
				
				$items = array();
				
				
				$commission = array();
				$commission["documentNo"] = $exitNo;
				$commission["externalDocumentno"] =$result["chequeNo"];
				$commission["transactionDate"] = $result["exitDate"];
				$commission["transactionType"] ="901";
				$commission["description"] = "Cheque commission of member exit member No:".$result["memberNo"];
				$commission["amount"] = $result["chequeCommission"]*-1;
				$commission["accountNumber"] ="023";
				$commission["accountType"] = "glaccount";
				$commission["user"] =$myUserName;
				array_push($items, $commission);
				
				$charge = array();
				$charge["documentNo"] = $exitNo;
				$charge["externalDocumentno"] =$result["chequeNo"];
				$charge["transactionDate"] = $result["exitDate"];
				$charge["transactionType"] ="901";
				$charge["description"] = "Withdrawal Charge for member ".$result["memberNo"];
				$charge["amount"] = $result["withdrawalCharge"]*-1;
				$charge["accountNumber"] ="024";
				$charge["accountType"] = "glaccount";
				$charge["user"] =$myUserName;
				array_push($items, $charge);
				
				$bank = array();
				$bank["documentNo"] = $exitNo;
				$bank["externalDocumentno"] =$result["chequeNo"];
				$bank["transactionDate"] = $result["exitDate"];
				$bank["transactionType"] ="901";
				$bank["description"] = "Contributions Refund for member ".$result["memberNo"];
				$bank["amount"] = $result["refundableContributions"]*-1;
				$bank["accountNumber"] =$result["bankCode"];
				$bank["accountType"] = "bank";
				$bank["user"] =$myUserName;
				array_push($items, $bank);
				
				$member = array();
				$member["documentNo"] = $exitNo;
				$member["externalDocumentno"] =$result["chequeNo"];
				$member["transactionDate"] = $result["exitDate"];
				$member["transactionType"] ="202";
				$member["description"] = "Contributions Refund on member exit";
				$member["amount"] = $result["chequeCommission"]+$result["withdrawalCharge"]+$result["refundableContributions"];
				$member["accountNumber"] =$result["memberNo"];
				$member["accountType"] = "member";
				$member["user"] =$myUserName;
				array_push($items, $member);
				
				$response = post($items,"memberexit", $exitNo);
			
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A member exit with the given number does not exist";
	}
}
else if($type=="reversereceipt"){
	if(isset($_POST["receiptNo"])){
		$receiptNo = mysqli_real_escape_string($conn, trim($_POST["receiptNo"]));
		//validate
		$getReceipt = "SELECT A.*, (SELECT Sum(Amount)  FROM `receiptline` where ReceiptNo = '$receiptNo') total, (SELECT RequiresRef FROM `paymentmethods` where Id = A.PaymentMethod) requiresRef FROM `receiptheader` A WHERE ReceiptNo = '$receiptNo' and Posted=1";
		$receiptRes = mysqli_query($conn, $getReceipt);
		if(mysqli_num_rows($receiptRes)<1){
				$response["status"] = false;
				$response["message"] ="The receipt does not exist or has not been posted";
		}
		$error = false;
		$message = "";
		while($receipt = mysqli_fetch_assoc($receiptRes)){
			$member = $receipt["Member"];
			$paymentMethod = $receipt["PaymentMethod"];
			$bank = $receipt["Bank"];
			$externalRef = $receipt["ExternalRefNo"];
			$payDate = $receipt["PaymentDate"];
			$receivedFrom = $receipt["ReceivedFrom"];
			$receiptTotal = $receipt["total"];
			$requiresRef = $receipt["requiresRef"];
			if($member==""){
				$message = "Please select member";
				$error = true;
			}
			if(!$paymentMethod>0){
				$message.= strlen($message)>0?"\n":"";
				$message .= "Please select a valid payment method";
				$error = true;
			}
			if(!$bank>0){
				$message.= strlen($message)>0?"\n":"";
				$message .= "Please select the bank receiving the payment";
				$error = true;
			}
			if($requiresRef){
				if($externalRef==""){
				$message.= strlen($message)>0?"\n":"";
				$message .= "Please enter the payment ref/ external document number";
				$error = true;	
				}
			}
			if($payDate==""){
					$message.= strlen($message)>0?"\n":"";
				$message .= "Please enter the payment date";
				$error = true;	
			}
			if($receivedFrom==""){
					$message.= strlen($message)>0?"\n":"";
				$message .= "Please enter the name of the person from whom the payment is received";
				$error = true;	
			}
			if(!$receiptTotal>0){
				$message.= strlen($message)>0?"\n":"";
				$message .= "The receipt appears blank. The total is zero";
				$error = true;	
			}
			if($error){
				$response["status"] = false;
				$response["message"] =$message;
			}else{
				
				
				//post receipt
				$items = array();
				$header = array();
				$header["documentNo"] = $receiptNo;
				$header["externalDocumentno"] = $externalRef;
				$header["transactionDate"] = $payDate;
				$header["transactionType"] = "601";
				$header["description"] = "Reversal Receipt $receiptNo";
				$header["amount"] = $receiptTotal*-1;
				$header["accountType"] = "bank";				
				$header["accountNumber"] =$bank;
				$header["user"] = $myUserName;
				
				
				
				array_push($items, $header);
				//$getLines = "SELECT A.*, B.Description transType FROM `receiptline` A left join transactiontypes B on A.TransactionType = B.Code where ReceiptNo = '$receiptNo'";
				$getLines = "SELECT A.*, B.Description transType, B.GLAccount transGlAccount, B.journalAccountType FROM `receiptline` A left join transactiontypes B on A.TransactionType = B.Code where ReceiptNo = '$receiptNo'";
				$linesRes = mysqli_query($conn, $getLines);
				while($line = mysqli_fetch_assoc($linesRes)){
				$receiptLine = array();
				$receiptLine["documentNo"] = $receiptNo;
				$receiptLine["externalDocumentno"] = $externalRef;
				$receiptLine["transactionDate"] = $payDate;
				$receiptLine["transactionType"] = $line["TransactionType"];
				$journalAccountType = $line["journalAccountType"];
				$receiptLine["description"] = $line["transType"]." from receipt $receiptNo $memberName";
				$receiptLine["amount"] = $line["Amount"]*-1;	
				//'','vehicle',''
				if($journalAccountType=="member"){
					$receiptLine["accountType"] ="member";				
					$receiptLine["accountNumber"] = $member;
				}else if($journalAccountType=="vehicle"){
					$receiptLine["accountType"] ="vehicle";				
					$receiptLine["accountNumber"] = $line["vehicle"];
				}else if($journalAccountType=="loan"){
					$receiptLine["accountType"] ="loan";				
					$receiptLine["accountNumber"] = $line["LoanNo"];
				}else{
					$receiptLine["accountType"] ="glaccount";				
					$receiptLine["accountNumber"] = $line["transGlAccount"];
				}
				$receiptLine["description"] = "Reverse ".$line["transType"]." from receipt $receiptNo";
				$receiptLine["amount"] = $line["Amount"];				
								
				$receiptLine["user"] = $myUserName;
				array_push($items, $receiptLine);
				}
				$response = post($items,"reversereceipt", $receiptNo);
				
				
			}
		
		}
	}
	
}
else if($type=="reverserecoverloan"){
	$recoveryNo = trim($_POST["recoveryNo"]);
	$tRecoveryNo = mysqli_real_escape_string($conn,$recoveryNo);
	$check = "SELECT * FROM `loanrecovery` WHERE `recoveryNo` =  '$tRecoveryNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if(!$result["posted"]){
			$response["status"] = false;
			$response["message"] = "The loan recovery has not been posted";
		}else{
			$balancingCharge = $result["balancingCharge"];
			$amountFromContributions = $result["amountFromContributions"];
			$loanRepayment = $amountFromContributions - $balancingCharge;
				$items = array();
				$header = array();
				$header["documentNo"] = $recoveryNo;
				$header["externalDocumentno"] = "";
				$header["transactionDate"] = $result["recoveryDate"];
				$header["transactionType"] = "202";
				$header["description"] = "Reverse Loan Recovery ".$result["loan"];
				$header["amount"] = $result["amountFromContributions"]*-1;
				$header["accountType"] ="member";
				$header["accountNumber"] =$result["member"];
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] =$recoveryNo;
				$line["externalDocumentno"] = "";
				$line["transactionDate"] = $result["recoveryDate"];
				$line["transactionType"] ="307";
				$line["description"] = "Reverse Loan Recovery From Contributions";
				$line["amount"] = $loanRepayment;
				$line["accountNumber"] =$result["loan"];
				$line["accountType"] = "loan";
				$line["user"] =$myUserName;
				array_push($items, $line);
				
				$charge = array();
				$charge["documentNo"] =$recoveryNo;
				$charge["externalDocumentno"] = "";
				$charge["transactionDate"] = $result["recoveryDate"];
				$charge["transactionType"] ="307";
				$charge["description"] = "Reverse Balancing Charge for Loan".$result["loan"];
				$charge["amount"] = $balancingCharge;
				$charge["accountNumber"] ="007";
				$charge["accountType"] = "glaccount";
				$charge["user"] =$myUserName;
				array_push($items, $charge);
				$response = post($items,"reverserecoverloan", $recoveryNo);
			
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A transfer voucher with the given number does not exist";
	}
}
else if($type=="banktransfer"){
	$transferNo = trim($_POST["transferNo"]);
	$tTransferNo = mysqli_real_escape_string($conn,$transferNo);
	$check = "SELECT * FROM `banktransfers` WHERE `transferNo` = '$tTransferNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The bank transfer has already been posted";
		}else{
				$items = array();
				$header = array();
				$externalRef = $result["externalRef"];
				$transferAmount = $result["amount"];
				$description = $result["description"];
				$header["documentNo"] = $transferNo;
				$header["externalDocumentno"] = $externalRef;
				$header["transactionDate"] = $result["transferDate"];
				$header["transactionType"] = "800";
				$header["description"] = $description;
				$header["amount"] = $transferAmount*-1;
				$header["accountType"] ="bank";
				$header["accountNumber"] =$result["fromBank"];
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] = $transferNo;
				$line["externalDocumentno"] = $externalRef;
				$line["transactionDate"] = $result["transferDate"];
				$line["transactionType"] ="800";
				$line["description"] = $description;
				$line["amount"] = $transferAmount;
				$line["accountNumber"] =$result["toBank"];
				$line["accountType"] = "bank";
				$line["user"] =$myUserName;
				array_push($items, $line);
				$response = post($items,"banktransfer", $transferNo);
		
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A bank transfer voucher with the given number does not exist";
	}
}
else if($type=="reversebanktransfer"){
	$transferNo = trim($_POST["transferNo"]);
	$tTransferNo = mysqli_real_escape_string($conn,$transferNo);
	$check = "SELECT * FROM `banktransfers` WHERE `transferNo` = '$tTransferNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if(!$result["posted"]){
			$response["status"] = false;
			$response["message"] = "The bank transfer has not been posted";
		}else{
				$items = array();
				$header = array();
				$externalRef = $result["externalRef"];
				$transferAmount = $result["amount"];
				$description = $result["description"];
				$header["documentNo"] = $transferNo;
				$header["externalDocumentno"] = $externalRef;
				$header["transactionDate"] = $result["transferDate"];
				$header["transactionType"] = "800";
				$header["description"] = "Reverse ".$description;
				$header["amount"] = $transferAmount;
				$header["accountType"] ="bank";
				$header["accountNumber"] =$result["fromBank"];
				$header["user"] =$myUserName;
				
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] = $transferNo;
				$line["externalDocumentno"] = $externalRef;
				$line["transactionDate"] = $result["transferDate"];
				$line["transactionType"] ="800";
				$line["description"] = "Reverse ".$description;
				$line["amount"] = $transferAmount*-1;
				$line["accountNumber"] =$result["toBank"];
				$line["accountType"] = "bank";
				$line["user"] =$myUserName;
				array_push($items, $line);
				$response = post($items,"reversebanktransfer", $transferNo);
		
		}
	}
		
	}else{
		$response["status"] = false;
		$response["message"] = "A bank transfer voucher with the given number does not exist";
	}
}
else if($type=="assetacquisition"){
	$acquisitionNo = trim($_POST["acquisitionNo"]);
	$tAcquisitionNo = mysqli_real_escape_string($conn, $acquisitionNo);
	$check = "SELECT A.*, (SELECT fixedAssetName FROM `fixedassets` WHERE faNo = A.assetNo) assetName FROM `assetacquisition` A WHERE `acquisitionNo` ='$tAcquisitionNo'";
	$res = mysqli_query($conn,$check);
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The asset acquisition has already been posted";
		}else{
			//vendor entries
			$buyingPrice = $result["buyingPrice"];
			$items = array();
			$header = array();
			$header["documentNo"] = $acquisitionNo;
			$header["externalDocumentno"] = "";
			$header["transactionDate"] = $result["purchaseDate"];
			$header["transactionType"] = "acquisition";
			$header["description"] = "Purchase of ".$result["assetName"]. " F.A. No ".$result["assetNo"];
			$header["amount"] = $buyingPrice*-1;
			$header["accountType"] ="vendor";
			$header["accountNumber"] =$result["vendorNo"];
			$header["user"] =$myUserName;
				
			array_push($items,$header);
				
			$line = array();
			$line["documentNo"] =$acquisitionNo;
			$line["externalDocumentno"] = "";
			$line["transactionDate"] = $result["purchaseDate"];
			$line["transactionType"] ="acquisition";
			$line["description"] = "Buying Price";
			$line["amount"] = $buyingPrice;
			$line["accountNumber"] =$result["assetNo"];
			$line["accountType"] = "fixedasset";
			$line["user"] =$myUserName;
			array_push($items, $line);
			$response = post($items,"assetacquisition", $acquisitionNo);
		}
	}
}
else if($type=="assetdisposal"){
	$disposalNo = trim($_POST["disposalNo"]);
	$tDisposalNo = mysqli_real_escape_string($conn, $disposalNo);
	$check = "SELECT A.*, (SELECT fixedAssetName FROM `fixedassets` WHERE faNo = A.assetNo) assetName,
	(SELECT SUM(Amount) FROM `fixedassetledgerentries` WHERE fixedAssetNo = A.assetNo) bookValue	FROM `assetdisposal` A WHERE `disposalNo` ='$tDisposalNo'";
	$res = mysqli_query($conn,$check);
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The asset disposal has already been posted";
		}else{
			//customer entries
			$bookValue = $result["bookValue"];
			$sellingPrice = $result["sellingPrice"];
			$difference = $sellingPrice - $bookValue;
			$items = array();
			$header = array();
			$header["documentNo"] = $disposalNo;
			$header["externalDocumentno"] = "";
			$header["transactionDate"] = $result["disposalDate"];
			$header["transactionType"] = "2002";
			$header["description"] = "Sale of ".$result["assetName"]. " F.A. No ".$result["assetNo"];
			$header["amount"] = $sellingPrice;
			$header["accountType"] ="customer";
			$header["accountNumber"] =$result["customerNo"];
			$header["user"] =$myUserName;
				
			array_push($items,$header);
				
			$line = array();
			$line["documentNo"] =$disposalNo;
			$line["externalDocumentno"] = "";
			$line["transactionDate"] = $result["disposalDate"];
			$line["transactionType"] ="2002";
			$line["description"] = "Selling Price";
			$line["amount"] = $bookValue*-1;
			$line["accountNumber"] =$result["assetNo"];
			$line["accountType"] = "fixedasset";
			$line["user"] =$myUserName;
			array_push($items, $line);
			
			$adjustment = array();
			$line["documentNo"] =$disposalNo;
			$line["externalDocumentno"] = "";
			$line["transactionDate"] = $result["disposalDate"];
			$line["transactionType"] ="2002";
			$line["description"] = "Gains/Loss on disposal of ".$result["assetName"]. " F.A. No ".$result["assetNo"];
			$line["amount"] = $difference*-1;
			$line["accountNumber"] ="032";
			$line["accountType"] = "glaccount";
			$line["user"] =$myUserName;
			array_push($items, $line);
			
			$response = post($items,"assetdisposal", $disposalNo);
		}
	}
}
else if($type=="appreciationdepreciation"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	//check that it exists
	//check that it has not been posted
	//check that the rate/amount is not zero
	//post
	$check = "SELECT A.*, (SELECT SUM(Amount) FROM `fixedassetledgerentries` WHERE fixedAssetNo = A.assetNo) bookValue FROM `appreciation_depreciation` A WHERE A.`voucherNo` = '$tVoucherNo'";
	$res = mysqli_query($conn, $check);
	if(mysqli_num_rows($res)>0){//exists
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The selected voucher has already been posted";
			}else{
				$rateAmount = $result["rateAmount"];
				if($rateAmount==0){
					$response["status"] = false;
					$response["message"] = "The rate/Amount of the vocuher cannot be zero";
				}else{
					$currentBookValue = $result["bookValue"]+0;
					$rateAmount = $result["rateAmount"];
					$change = 0;
					$type = $result["computationType"];
					$method = $result["computationMethod"];
					$description = $result["description"];
					$assetNo = $result["assetNo"];
					if($method=="Percentage"){
						$change = ($currentBookValue*$rateAmount)/100;
					}else if($method=="Fixed amount"){
						$change = $rateAmount;
					}
					if($type=="Depreciation"){
						$change = $change*-1;
					}
					$items = array();
					$header = array();
					$header["documentNo"] = $voucherNo;
					$header["externalDocumentno"] = "";
					$header["transactionDate"] = $result["computationDate"];
					$header["transactionType"] = "2003";
					$header["description"] = $description;
					$header["amount"] = $change;
					$header["accountType"] ="fixedasset";
					$header["accountNumber"] =$assetNo;
					$header["user"] =$myUserName;
					
					array_push($items,$header);
					//g/l account
					$line = array();
					$line["documentNo"] =$voucherNo;
					$line["externalDocumentno"] = "";
					$line["transactionDate"] = $result["computationDate"];
					$line["transactionType"] ="2003";
					$line["description"] = $assetNo." " .$description;
					$line["amount"] = $change*-1;
					$line["accountNumber"] ="033";
					$line["accountType"] = "glaccount";
					$line["user"] =$myUserName;
					array_push($items, $line);
					
					$response = post($items,"appreciationdepreciation", $voucherNo);
				}
			}
		}
		
	}else{//does not exist
		$response["status"] = false;
		$response["message"] = "A voucher with the given number does not exist";
	}
}
else if($type=="salaryvoucher"){
	//echo "hi victor";
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	//check voucher exists
	//check that it has  not been posted
	//check that it has entries
	//post
	$sql = "SELECT * FROM `salaryvouchers` WHERE `voucherNo` = '$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){
	while($result = mysqli_fetch_assoc($res)){
		$disbursementDate = $result["disbursement_date"];
		$payingBank = $result["payingBank"];
		$year = $result["year"];
		$month = $result["month"];
		$period = getMonthName($month)." ".$year;
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The salary voucher has already been posted";
		}else{
			$linesSql ="SELECT * FROM `salaryvoucherlines` WHERE `voucherNo` = '$tVoucherNo'";
			$linesres = mysqli_query($conn,$linesSql);
			if(mysqli_num_rows($linesres)>0){
				$entries = array();
				$netPay = 0;
				$salaryAdvanceCode= getSalaryAdvanceCode();
				$staffLoanCode= getStaffLoanCode();				
				$getDeductions = "SELECT A.*, (SELECT SUM(amount) FROM `salaryvoucherlines` WHERE type = 'deduction' AND voucherNo ='$tVoucherNo' AND allowance_deduction_code = A.code) total FROM `allowancesdeductions` A WHERE A.type = 'deduction' and code in (SELECT DISTINCT(allowance_deduction_code) FROM `salaryvoucherlines` WHERE voucherNo ='$tVoucherNo' and type='deduction')";
				//echo $getDeductions;
				$deductionsRes = mysqli_query($conn, $getDeductions);
				while($deductionsResult = mysqli_fetch_assoc($deductionsRes)){
					// and not allowance_deduction_code in ('','')
					$code = $deductionsResult["code"];
					if(!($code==$salaryAdvanceCode||$code==$staffLoanCode)){
    					$amount = $deductionsResult["total"];
    					$netPay-=$amount;
    					$name = $deductionsResult["name"];
    					$deduction = array();
    					$deduction["documentNo"] = $voucherNo;
    					$deduction["externalDocumentno"] = "";
    					$deduction["transactionDate"] = $disbursementDate;
    					$deduction["transactionType"] = "5001";
    					$deduction["description"] = "$name for the period $period";
    					$deduction["amount"] = $amount*-1;
    					$deduction["accountType"] =$deductionsResult["link_to"];
    					$deduction["accountNumber"] =$deductionsResult["vendorGlAccount"];
    					$deduction["user"] =$myUserName;
    							
    					array_push($entries,$deduction);
					}
				}
				//loans and salary advances
				$getDeductions = "SELECT B.vendorGlAccount,B.name,A.* FROM `salaryvoucherlines` A left join allowancesdeductions B on A.allowance_deduction_code = B.code WHERE A.type = 'deduction' AND voucherNo ='$tVoucherNo'  and  allowance_deduction_code in ('$salaryAdvanceCode')";
				//echo $getDeductions."Hi Victor";
				$deductionsRes = mysqli_query($conn, $getDeductions);
				while($deductionsResult = mysqli_fetch_assoc($deductionsRes)){
					$amount = $deductionsResult["amount"];
					$netPay-=$amount;
					$name = $deductionsResult["name"];
					$deduction = array();
					$deduction["documentNo"] = $voucherNo;
					$deduction["externalDocumentno"] = "";
					$deduction["transactionDate"] = $disbursementDate;
					$deduction["transactionType"] = "5001";
					$deduction["description"] = "$name for the period $period";
					$deduction["amount"] = $amount*-1;
					$deduction["accountType"] ="salaryadvance";
					$deduction["accountNumber"] =$deductionsResult["accountNumber"];
					$deduction["user"] =$myUserName;
					//print_r($deduction);
							
					array_push($entries,$deduction);
				}
				$getDeductions = "SELECT A.*,B.vendorGlAccount,B.name FROM `salaryvoucherlines` A left join allowancesdeductions B on A.allowance_deduction_code = B.code WHERE A.type = 'deduction' AND voucherNo ='$tVoucherNo'  and  allowance_deduction_code in ('$staffLoanCode')";
				//echo $getDeductions;
				$deductionsRes = mysqli_query($conn, $getDeductions);
				while($deductionsResult = mysqli_fetch_assoc($deductionsRes)){
					$amount = $deductionsResult["amount"];
					$netPay-=$amount;
					$name = $deductionsResult["name"];
					$deduction = array();
					$deduction["documentNo"] = $voucherNo;
					$deduction["externalDocumentno"] = "";
					$deduction["transactionDate"] = $disbursementDate;
					$deduction["transactionType"] = "5001";
					$deduction["description"] = "$name for the period $period";
					$deduction["amount"] = $amount*-1;
					$deduction["accountType"] ="staffloan";
					$deduction["accountNumber"] =$deductionsResult["accountNumber"];
					$deduction["user"] =$myUserName;
							
					array_push($entries,$deduction);
				}
				
				
				/*$getEarnings = "SELECT A.*, (SELECT SUM(amount) FROM `salaryvoucherlines` WHERE type = 'earning' AND voucherNo ='$tVoucherNo' AND allowance_deduction_code = A.code) total FROM `allowancesdeductions` A WHERE A.type = 'earning' and code in (SELECT DISTINCT(allowance_deduction_code) FROM `salaryvoucherlines` WHERE voucherNo ='$tVoucherNo' and type='earning')";
				$earningsRes = mysqli_query($conn, $getEarnings);
				while($earningsResult = mysqli_fetch_assoc($earningsRes)){
					$amount = $earningsResult["total"];
					$netPay+=$amount;
					$name = $earningsResult["name"];
					$earning = array();
					$earning["documentNo"] = $voucherNo;
					$earning["externalDocumentno"] = "";
					$earning["transactionDate"] = $disbursementDate;
					$earning["transactionType"] = "5001";
					$earning["description"] = "$name for the period $period";
					$earning["amount"] = $amount;
					$earning["accountType"] ="glaccount";
					$earning["accountNumber"] =$earningsResult["vendorGlAccount"];
					$earning["user"] =$myUserName;
							
					array_push($entries,$earning);
				}*/
				
				$getEarnings = "SELECT A.*,B.region_code,C.rsmCode,D.vendorGlAccount,D.name deductionName FROM `salaryvoucherlines` A left JOIN employee B on A.employeeNo = B.EmployeeNumber left join regions C on B.region_code=C.id LEFT join allowancesdeductions D on A.allowance_deduction_code = D.code WHERE A.type = 'earning' AND A.voucherNo ='$tVoucherNo' ";
				$earningsRes = mysqli_query($conn, $getEarnings);
				while($earningsResult = mysqli_fetch_assoc($earningsRes)){
					$amount = $earningsResult["amount"];
					$netPay+=$amount;
					$name = $earningsResult["deductionName"];
					$earning = array();
					$earning["documentNo"] = $voucherNo;
					$earning["externalDocumentno"] = "";
					$earning["transactionDate"] = $disbursementDate;
					$earning["transactionType"] = "5001";
					$earning["description"] = "$name for the period $period";
					$earning["amount"] = $amount;
					$earning["accountType"] ="glaccount";
					$earning["accountNumber"] =$earningsResult["vendorGlAccount"];
					$earning["regionCode"] =$earningsResult["region_code"];
					$earning["salesRep"] =$earningsResult["rsmCode"];
					$earning["user"] =$myUserName;
							
					array_push($entries,$earning);
				}
				
				$netPayEntry = array();
				$netPayEntry["documentNo"] = $voucherNo;
				$netPayEntry["externalDocumentno"] = "";
				$netPayEntry["transactionDate"] = $disbursementDate;
				$netPayEntry["transactionType"] = "5001";
				$netPayEntry["description"] = "Netpay for the period $period";
				$netPayEntry["amount"] = $netPay*-1;
				$netPayEntry["accountType"] ="glaccount";//"bank";
				$netPayEntry["accountNumber"] ="L0002";//$payingBank;
				$netPayEntry["user"] =$myUserName;
				//L0002			
				array_push($entries,$netPayEntry);
				//print_r($entries);
				$response = post($entries,"salaryvoucher", $voucherNo);	
				}
			else{
				$response["status"] = false;
				$response["message"] = "The salary voucher does not have any lines";
			}
		}
	}
	}else{
		$response["status"] = false;
		$response["message"] = "The salary voucher does not exist";
	}
}

else if($type=="vendorinvoice"){
	if(isset($_POST["invoiceNo"])){
	$invoiceNo = mysqli_real_escape_string($conn, trim($_POST["invoiceNo"]));
	$sql = "SELECT A.*,B.*,C.*,(SELECT Sum(totalAmount) FROM `vendorinvoicelines` where invoiceNo = A.invoiceNo) totalAmount,NOW() currentTime FROM `vendorinvoices` A left join vendors B on A.vendor = B.vendorNumber left join postinggroups C on B.vendorpostinggroup = C.id  where A.invoiceNo ='$invoiceNo' and A.posted=0";
	$res = mysqli_query($conn, $sql);
	while($result = mysqli_fetch_assoc($res)){
		$error = false;
		$invoiceDate = "";
		$message = "";
		//check vendor has been selected
		$vendorNumber = $result["vendorNumber"];
		$documentType = $result["document_type"];
		//$customerNumber = $result["vendorNumber"];
		$shopLocationCode = $result["shopLocationCode"];
		$invoiceDate = $result["invoiceDate"];
		$externalRef = $result["external_doc_no"];
		
		if($vendorNumber==""){
			$error = true;
			$message.=strlen($message)>0?"\n":"";
			$message.="The invoice does not have a vendor. Kindly select";
		}
		if($shopLocationCode<1){
			$error = true;
			$message.=strlen($message)>0?"\n":"";
			$message.="The invoice does not have a location. Kindly select";
		}
		
		
		//check customer has a posting group
		$vendorPostingGroup = $result["id"];
		if(!is_numeric($vendorPostingGroup)||$vendorPostingGroup<1){
			$error = true;
			$message.=strlen($message)>0?"\n":"";
			$message.="The selected vendor does not have a vendor posting group. Please update the vendor before posting.";
		}
		
		//check posting group has a g/l account
		$glaccount = $result["glaccount"];
		if($glaccount==""){
			$error = true;
			$message.=strlen($message)>0?"\n":"";
			$message.="The vendor's posting group does not have a G/L Account. Please update";
		}
		//check invoice total is greater than 0
		
		$totalAmount = $result["totalAmount"];
		if($totalAmount<0){
			$error = true;
			$message.=strlen($message)>0?"\n":"";
			$message.="The invoice total amount is less than zero. Kindly add invoice lines";
		}
		if($error){
			$response["status"] = false;
			$response["message"] =$message;
		}
		else if($documentType=="lpo"){
            //check if vendor is kisaju
            if($vendorNumber=="0001"){
                 //validate
                 $lines = fetchWithPdo("SELECT A.unitPrice,B.dms_no,B.postingGroup,B.name itemName,A.approved_quantity quantity FROM `vendorinvoicelines` A LEFT JOIN items B on A.itemNo = B.code WHERE A.invoiceNo = ? AND A.itemType = 'Items'; ",array($invoiceNo));
                 foreach($lines as $line){
                     $dmsNo = trim($line["dms_no"]);
                     $unitPrice = trim($line["unitPrice"]);
                     $postingGroup = trim($line["postingGroup"]);
                     $itemName = trim($line["itemName"]);
                     $quantity = trim($line["quantity"]);
                     $packaging = 1;
                     if($postingGroup==19){//cans
                         $packaging = 3;
                     }else if($postingGroup==20){//beers
                         $packaging = 25;
                     }
                     $remainder = $quantity % $packaging;
                     if(strlen($dmsNo)<4){
                         $error = true;
			             $message.=strlen($message)>0?"\n":"";
			             $message.="DMS No of $itemName has not been defined";
                     }
                     if($unitPrice<1){
                         $error = true;
			             $message.=strlen($message)>0?"\n":""; 
			             $message.="Unit price of $itemName cannot be zero";
                     }
                     if($remainder>0){
                         $error = true;
			             $message.=strlen($message)>0?"\n":"";
			             $message.="Invalid quantity for $itemName";
                     }
                 }
                 //Cans and crates, must be factors of packaging
                 //Cannot approve if dms no not defined, if price is zero 
                
            }
            if($error){
                $response["status"] = false;
			    $response["message"] =$message;
            }else{
		        $sql = "UPDATE `vendorinvoices` SET status ='Approved', posted =1, postedOn=NOW() WHERE invoiceNo=? AND document_type=? limit 1";
		        $values= array($invoiceNo,$documentType);
		        if(pdoExecute($sql,$values)){
		            $response["status"] = true;
			        $response["message"] ="The L.P.O. was successfully approved";
			        createSalesDocumentOnEnterprises($invoiceNo, "SalesOrder");
		        }else{
		            $response["status"] = false;
			        $response["message"] ="The L.P.O. could not be approved";
		        }
            }
		}
		else{
				$items = array();
				$vendorName = getAccountName("vendor",$vendorNumber);
			    $invoiceTotal = 0;
				$getLines = "SELECT A.*,B.*,A.description customDesc FROM `vendorinvoicelines` A left join chargeitems B on A.itemNo = B.id where invoiceNo = '$invoiceNo' and itemType = 'Services'";
				$linesRes = mysqli_query($conn,$getLines);
				while($lineResult = mysqli_fetch_assoc($linesRes)){
					$multiplier = 1;
					if($documentType=="debitNote"){
						$multiplier = -1;
						//$shopLocationCode=1;
					}
					$totalVat = round($lineResult["totalVat"],2);
					$exclVat = $lineResult["totalAmount"]-$totalVat;
					$line = array();
					$line["documentNo"] = $invoiceNo;
					$line["transactionDate"] = $invoiceDate;
					$line["externalDocumentno"] = $externalRef;
					$line["transactionType"] =$documentType;
					$line["description"] = $vendorName." ".$lineResult["customDesc"];  
					//$line["amount"] = $lineResult["totalAmount"]*$multiplier;
					$line["amount"] = $exclVat*$multiplier;
					$line["accountType"] ="glaccount";
					$line["accountNumber"] =$lineResult["account_no"];
					$line["user"] =$myUserName;
					$line["region"] =$shopLocationCode;
					array_push($items, $line);
					
					$vat = array();
					$vat["documentNo"] = $invoiceNo;
					$vat["externalDocumentno"] = $externalRef;
					$vat["transactionDate"] = $invoiceDate;
					$vat["transactionType"] = $documentType;
					$vat["description"] = $vendorName." ".$lineResult["customDesc"];  
					$vat["amount"] = $totalVat*$multiplier;
					$vat["accountType"] ="glaccount";
					$vat["accountNumber"] =getVATAccount();
					$vat["user"] =$myUserName;
					$vat["region"] =$shopLocationCode;
					array_push($items, $vat);
					
					
					$invoiceTotal+=$lineResult["totalAmount"];
					$header = array();
    				$header["documentNo"] = $invoiceNo;
    				$header["externalDocumentno"] = $externalRef;
    				$header["transactionDate"] = $invoiceDate;
    				$header["transactionType"] = $documentType;
    				$header["description"] = $lineResult["customDesc"];
    				$header["amount"] = $lineResult["totalAmount"]*-1*$multiplier;				
    				$header["accountType"] ="vendor";
    				$header["accountNumber"] =$vendorNumber;
    				$header["user"] =$myUserName;
    				$header["region"] =$shopLocationCode;
    				array_push($items, $header);
					
				}
				$getLines = "SELECT A.*,B.*, A.description lineDescription FROM `vendorinvoicelines` A left join items B on A.itemNo = B.code where invoiceNo = '$invoiceNo' and itemType = 'Items' ";
				$linesRes = mysqli_query($conn,$getLines);
				while($lineResult = mysqli_fetch_assoc($linesRes)){
					$multiplier = 1;
					if($documentType=="debitNote"){
						$multiplier = -1;
					}
					
					$totalVat = round($lineResult["totalVat"],2);
					$exclVat = $lineResult["totalAmount"]-$totalVat;
					$inventory = array();
					$inventory["documentNo"] = $invoiceNo;
					$inventory["externalDocumentno"] = $externalRef;
					$inventory["transactionDate"] = $invoiceDate;
					$inventory["transactionType"] = $documentType;
					$inventory["description"] = $vendorName." ".$lineResult["lineDescription"];  
					$inventory["quantity"] = $lineResult["quantity"]*$multiplier;  
					$inventory["amount"] = $exclVat*$multiplier;
					$inventory["accountType"] ="item";
					$inventory["accountNumber"] =$lineResult["code"];
					$inventory["location"] =$shopLocationCode;
					$inventory["region"] =$shopLocationCode;
					
					$inventory["user"] =$myUserName;
					array_push($items, $inventory);
					
					
					$vat = array();
					$vat["documentNo"] = $invoiceNo;
					$vat["externalDocumentno"] = $externalRef;
					$vat["transactionDate"] = $invoiceDate;
					$vat["transactionType"] = $documentType;
					$vat["description"] = $vendorName." ".$lineResult["lineDescription"];  
					$vat["amount"] = $totalVat*$multiplier;
					$vat["accountType"] ="glaccount";
					$vat["accountNumber"] =getVATAccount();
					$vat["user"] =$myUserName;
					$vat["region"] =$shopLocationCode;
					array_push($items, $vat);
					
					$invoiceTotal+=$lineResult["totalAmount"];
					if(strlen($shopLocationCode)<1){
						$error = true;
						$message.=strlen($message)>0?"\n":"";
						$message.="Please select the shop location";
					}	
					
					
					$header = array();
    				$header["documentNo"] = $invoiceNo;
    				$header["externalDocumentno"] = $externalRef;
    				$header["transactionDate"] = $invoiceDate;
    				$header["transactionType"] = $documentType;
    				$header["description"] = $lineResult["lineDescription"];
    				$header["amount"] = $lineResult["totalAmount"]*-1*$multiplier;				
    				$header["accountType"] ="vendor";
    				$header["accountNumber"] =$vendorNumber;
    				$header["user"] =$myUserName;
    				$header["region"] =$shopLocationCode;
    				array_push($items, $header);
				}
			//	print_r($items);	
				if($error){
					$response["status"] = false;
					$response["message"] =$message;
				}else{					
					$response = post($items,"vendorinvoice", $invoiceNo);
					if($response["status"]){
						$lines = fetchWithPdo("SELECT A.* FROM `vendorinvoicelines` A where invoiceNo = ? and itemType = 'Items' ",array($invoiceNo));
						foreach($lines as $line){
							$sql = "UPDATE `items` SET `buying_price`=? where `code`=? limit 1";
							pdoExecute($sql,array($line["unitPrice"],$line["itemNo"]));
						}
						createSalesDocumentOnEnterprises($invoiceNo, "salesInvoice");
						//$purchaseResponse = sendPurchaseToEtims($invoiceNo);
						//$response["message"] = $response["message"].json_encode($purchaseResponse);	
					}
				}
				
		}
	}
}


	
}
else if($type=="parkingreceipt"){
	$receiptNo = trim($_POST["receiptNo"]);
	$tReceiptNo = mysqli_real_escape_string($conn, $receiptNo);
	$sql = "SELECT A.*, (SELECT SUM(amount) FROM `parkingreceiptlines` WHERE receiptNo = A.receiptNo) linesTotal FROM `parkingreceiptheader` A WHERE A.receiptNo = '$tReceiptNo'";
	$res= mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)<1){
			$response["status"] = false;
			$response["message"] = "The receipt does not exist";
	}else{
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The receipt has already been posted";
		}else{
			if($result["linesTotal"]>0){
					$description = $result["vehicle"]." Parking fee for the period ".getMonthName($result["month"])." ".$result["year"];
					$date = $result["paymentDate"];
					$items = array();
					$header = array();
					$header["documentNo"] = $receiptNo;
					$header["externalDocumentno"] = $result["externalDocNo"];
					$header["transactionDate"] = $date;
					$header["transactionType"] = "7001";
					$header["description"] = $description;
					$header["amount"] = $result["linesTotal"];
					$header["accountType"] ="bank";
					$header["accountNumber"] =$result["bank"];
					$header["user"] =$myUserName;					
					array_push($items,$header);
					
					$lineSql = "SELECT A.*, B.* FROM `parkingreceiptlines` A left join towns B on A.townId = B.townId WHERE receiptNo = '$tReceiptNo'";
					$linesres = mysqli_query($conn,$lineSql);
					while($lineResult = mysqli_fetch_assoc($linesres)){				
						$county = array();
						$county["documentNo"] =$receiptNo;
						$county["externalDocumentno"] = $result["externalDocNo"];
						$county["transactionDate"] = $date;
						$county["transactionType"] ="7001";
						$county["description"] = $description;
						$county["amount"] = $lineResult["countyMonthlyFee"]*-1;
						$county["accountNumber"] =$lineResult["county"];
						$county["accountType"] = "vendor";
						$county["user"] =$myUserName;
						array_push($items, $county);
						$income = array();
						$income["documentNo"] =$receiptNo;
						$income["externalDocumentno"] = $result["externalDocNo"];
						$income["transactionDate"] = $date;
						$income["transactionType"] ="7001";
						$income["description"] = $description;
						$income["amount"] = ($lineResult["saccoMonthlyFee"]-$lineResult["countyMonthlyFee"])*-1;
						$income["accountNumber"] ="010";
						$income["accountType"] = "glaccount";
						$income["user"] =$myUserName;
						array_push($items, $income);
					}
					$response = post($items,"parkingreceipt", $receiptNo);
			}else{
				$response["status"] = false;
				$response["message"] = "The receipt total cannot be zero";
			}
		}
	}
	}
}
else if($type=="pettycashvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	$sql = "select A.*,(select Sum(amount) from pettycashvoucherlines where pcvNo = A.pcvNo) linesTotal from pettycashvouchers A where A.pcvNo = '$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)<1){
		$response["status"] = false;
		$response["message"] ="A petty cash voucher with the given P.C.V. No does not exist";
	}
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] ="A petty cash voucher with the given P.C.V. No has already been posted";
		}else{
			$linesTotal = $result["linesTotal"]+0;
			if($linesTotal ==0){
				$response["status"] = false;
				$response["message"] ="The total amount of the petty cash voucher cannot be zero!";
			}else{
				$bank = $result["bank"];
				$pcvDate = $result["pcvDate"];
				$externalRef = $result["externalRef"];
				
				$regionCode ="";// $result["regionCode"];
				$salesRep = $result["salesRep"];
				//, 
				
				$lines = "select A.*, A.description lineDescription,B.* from pettycashvoucherlines A left join chargeitems B on A.chargeitem = B.id where pcvNo = '$tVoucherNo'";
				$linesRes = mysqli_query($conn, $lines);
				$items = array();
				$total = 0;
				//region salesRep
				while($linesResult = mysqli_fetch_assoc($linesRes)){
					$line = array();
					$line["documentNo"] = $voucherNo;
					$line["externalDocumentno"] = $externalRef;
					$line["transactionDate"] = $pcvDate;
					$line["transactionType"] = $linesResult["chargeitem"];
					$line["description"] = $linesResult["lineDescription"];  
					$line["amount"] = $linesResult["amount"];
					$line["accountType"] ="glaccount";
					$line["accountNumber"] =$linesResult["account_no"];
					$line["region"] =$linesResult["region_code"];
					$line["salesRep"] =$linesResult["sales_rep"];;
					$line["user"] =$myUserName;
					$total +=$linesResult["amount"];
					array_push($items, $line);
				}
					$header = array();
					$header["documentNo"] = $voucherNo;
					$header["externalDocumentno"] = $externalRef;
					$header["transactionDate"] = $pcvDate;
					$header["transactionType"] = "1600";
					$header["description"] = "Petty Cash Voucher $voucherNo";  
					$header["amount"] = $total*-1;
					$header["accountType"] ="bank";
					$header["accountNumber"] =$bank;
					$header["region"] =$regionCode;
					$header["salesRep"] =$salesRep;
					$header["user"] =$myUserName;
					array_push($items, $header);
					$response =post($items,"pettycashvoucher", $voucherNo);
			}
		}
	}
}
else if($type=="reversepettycashvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	$sql = "select A.*,(select Sum(amount) from pettycashvoucherlines where pcvNo = A.pcvNo) linesTotal from pettycashvouchers A where A.pcvNo = '$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)<1){
		$response["status"] = false;
		$response["message"] ="A petty cash voucher with the given P.C.V. No does not exist";
	}
	while($result = mysqli_fetch_assoc($res)){
		if(!$result["posted"]){
			$response["status"] = false;
			$response["message"] ="A petty cash voucher with the given P.C.V. No has not been posted";
		}else{
			$linesTotal = $result["linesTotal"]+0;
			if($linesTotal ==0){
				$response["status"] = false;
				$response["message"] ="The total amount of the petty cash voucher cannot be zero!";
			}else{
				$bank = $result["bank"];
				$pcvDate = $result["pcvDate"];
				$externalRef = $result["externalRef"];
				$lines = "select A.*, A.description lineDescription,B.* from pettycashvoucherlines A left join chargeitems B on A.chargeitem = B.id where pcvNo = '$tVoucherNo'";
				$linesRes = mysqli_query($conn, $lines);
				$items = array();
				$total = 0;
				while($linesResult = mysqli_fetch_assoc($linesRes)){
					$line = array();
					$line["documentNo"] = $voucherNo;
					$line["externalDocumentno"] = $externalRef;
					$line["transactionDate"] = $pcvDate;
					$line["transactionType"] = $linesResult["chargeitem"];
					$line["description"] = "Reversal ".$linesResult["lineDescription"];  
					$line["amount"] = $linesResult["amount"]*-1;
					$line["accountType"] ="glaccount";
					$line["accountNumber"] =$linesResult["account_no"];
					$line["user"] =$myUserName;
					$total +=$linesResult["amount"];
					$line["region"] =$linesResult["region_code"];
					$line["salesRep"] =$linesResult["sales_rep"];;
					array_push($items, $line);
				}
					$header = array();
					$header["documentNo"] = $voucherNo;
					$header["externalDocumentno"] = $externalRef;
					$header["transactionDate"] = $pcvDate;
					$header["transactionType"] = "1600";
					$header["description"] = "Reversal of Petty Cash Voucher $voucherNo";  
					$header["amount"] = $total;
					$header["accountType"] ="bank";
					$header["accountNumber"] =$bank;
					$header["user"] =$myUserName;
					array_push($items, $header);
					$response = post($items,"reversepettycashvoucher", $voucherNo);
			}
		}
	}
}
else if($type=="directincome"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	$sql = "SELECT * FROM `directincome` WHERE `voucherNo` = '$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The income voucher has already been posted";
		}else{
			$items = array();
			$bank = array();
			$bank["documentNo"] =$voucherNo;
			$bank["externalDocumentno"] = $result["externalDocNo"];
			$bank["transactionDate"] = $result["voucherDate"];
			$bank["transactionType"] ="8001";
			$bank["description"] =$result["description"];
			$bank["amount"] = $result["amount"];
			$bank["accountNumber"] =$result["bank"];
			$bank["accountType"] = "bank";
			$bank["user"] =$myUserName;
			array_push($items, $bank);
			$glEntry = array();
			$glEntry["documentNo"] =$voucherNo;
			$glEntry["externalDocumentno"] = $result["externalDocNo"];
			$glEntry["transactionDate"] = $result["voucherDate"];
			$glEntry["transactionType"] ="8001";
			$glEntry["description"] =$result["description"];
			$glEntry["amount"] = $result["amount"]*-1;
			$glEntry["accountNumber"] =$result["glAccount"];
			$glEntry["accountType"] = "glaccount";
			$glEntry["user"] =$myUserName;
			array_push($items, $glEntry);
			$response = post($items,"directincome", $voucherNo);
		}
	}
	
}
else if($type=="reversedirectincome"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	$sql = "SELECT * FROM `directincome` WHERE `voucherNo` = '$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	while($result = mysqli_fetch_assoc($res)){
		if(!$result["posted"]){
			$response["status"] = false;
			$response["message"] = "The income voucher has not been posted";
		}else{
			$items = array();
			$bank = array();
			$bank["documentNo"] =$voucherNo;
			$bank["externalDocumentno"] = $result["externalDocNo"];
			$bank["transactionDate"] = $result["voucherDate"];
			$bank["transactionType"] ="8001";
			$bank["description"] ="Reverse ".$result["description"];
			$bank["amount"] = $result["amount"]*-1;
			$bank["accountNumber"] =$result["bank"];
			$bank["accountType"] = "bank";
			$bank["user"] =$myUserName;
			array_push($items, $bank);
			$glEntry = array();
			$glEntry["documentNo"] =$voucherNo;
			$glEntry["externalDocumentno"] = $result["externalDocNo"];
			$glEntry["transactionDate"] = $result["voucherDate"];
			$glEntry["transactionType"] ="8001";
			$glEntry["description"] ="Reverse ".$result["description"];
			$glEntry["amount"] = $result["amount"];
			$glEntry["accountNumber"] =$result["glAccount"];
			$glEntry["accountType"] = "glaccount";
			$glEntry["user"] =$myUserName;
			array_push($items, $glEntry);
			$response = post($items,"reversedirectincome", $voucherNo);
		}
	}
	
}
else if($type=="expressSale"){
	//check if express sale has been posted
	//check if it has lines
	$code = trim($_POST['code']);
	$sel = "SELECT A.*, B.accountNumber, B.gl_account FROM `expressSales` A LEFT JOIN `banks` B ON B.Id = A.bank WHERE `code`='$code'";
	$res = mysqli_query($conn, $sel);
	if (mysqli_num_rows($res)>0) {
		$row = mysqli_fetch_assoc($res);
		$posted = $row['posted'];
		$accountNumber = $row['accountNumber'];
		$glAccount = $row['gl_account'];
		$extDoc = $row['externalDocNo'];
		$date = $row['dateCreated'];
		$bank = $row['bank'];
		$location = $row['location'];
		if ($posted==0) {
			$lines = "SELECT A.*, B.*, C.externalDocNo, C.dateCreated FROM `expresssalelines` A LEFT JOIN `items` B ON B.code = A.item LEFT JOIN `expressSales` C ON C.code=A.saleCode WHERE `saleCode` = '$code'";
			$getLines = mysqli_query($conn, $lines);
			if (mysqli_num_rows($getLines)>0) {
				# post...
				$totals=0;
				$items = array();
				while ($row = mysqli_fetch_assoc($getLines)) {
					$line = array();
					
					$line['documentNo'] = $code;
					$line['externalDocumentno'] = $extDoc;
					$line['transactionDate'] = $date;
					$line['item'] = $row['item'];
					$line['transactionType'] = $row['item'];
					$line['accountType'] = "item";
					$line['accountNumber'] = $row['item'];
					$line['description'] = 'Item Express Sale '.$code;
					$line['unitPrice'] = $row['unitPrice'];
					$line['location'] = $location;
					$quantity= $row['quantity'];
					$line['quantity'] = $quantity*-1;
					$unitPrice = $row['unitPrice'];
					$total=$quantity*$unitPrice;
					$total = $total*-1;
					$line['total'] = $total;
					$line['amount'] = $total;
					$totals += $total;
					$line['user'] = 1;
					array_push($items, $line);
				}
					$header = array();
					$header["documentNo"] = $code;
					$header["externalDocumentno"] = $extDoc;
					$header["transactionDate"] = $date;
					$header["transactionType"] = "20003";
					$header["description"] = "Express Sale ".$code;  
					$header["amount"] = $totals*-1;
					$header["accountType"] ="bank";
					$header["accountNumber"] =$bank;
					$header["user"] =$myUserName;
					array_push($items, $header);
				$response = post($items,"expresssale", $code);
			}
			else{
				$response['status']=false;
				$response['message']="This sale has no items for posting";
			}
		}else{
			$response['status']=false;
			$response['message']="This sale has already been posted";
		}
	}else{
		$response['status']=false;
		$response['message']="This sale does not exist";
	}

}
else if($type=="reverseexpressSale"){
	//check if sale exists and has been posted and has not been reversed

	$code = trim($_POST['code']);
	$sel = "SELECT A.*, B.accountNumber, B.gl_account FROM `expressSales` A LEFT JOIN `banks` B ON B.Id = A.bank WHERE `code`='$code'";
	$res = mysqli_query($conn, $sel);
	if (mysqli_num_rows($res)>0) {
		$row = mysqli_fetch_assoc($res);
		$posted = $row['posted'];
		$reversed = $row['reversed'];
		$accountNumber = $row['accountNumber'];
		$glAccount = $row['gl_account'];
		$extDoc = $row['externalDocNo'];
		$date = $row['dateCreated'];
		$bank = $row['bank'];
		$location = $row['location'];
		if ($posted==1) {
			if ($reversed==0) {
				$lines = "SELECT A.*, B.*, C.externalDocNo, C.dateCreated FROM `expresssalelines` A LEFT JOIN `items` B ON B.code = A.item LEFT JOIN `expressSales` C ON C.code=A.saleCode WHERE `saleCode` = '$code'";
				$getLines = mysqli_query($conn, $lines);
				if (mysqli_num_rows($getLines)>0) {
					# post...
					$totals=0;
					$items = array();
					while ($row = mysqli_fetch_assoc($getLines)) {
						$line = array();
						
						$line['documentNo'] = $code;
						$line['externalDocumentno'] = $extDoc;
						$line['transactionDate'] = $date;
						$line['item'] = $row['item'];
						$line['transactionType'] = $row['item'];
						$line['accountType'] = "item";
						$line['accountNumber'] = $row['item'];
						$line['description'] = 'Reverse Express Sale '.$code;
						$line['unitPrice'] = $row['unitPrice'];
						$line['location'] = $location;
						$quantity= $row['quantity'];
						$line['quantity'] = $quantity;
						$unitPrice = $row['unitPrice'];
						$total=$quantity*$unitPrice;
						$total = $total;
						$line['total'] = $total;
						$line['amount'] = $total;
						$totals += $total;
						$line['user'] = 1;
						array_push($items, $line);
					}
						$header = array();
						$header["documentNo"] = $code;
						$header["externalDocumentno"] = $extDoc;
						$header["transactionDate"] = $date;
						$header["transactionType"] = "20003";
						$header["description"] = "Reverse Express Sale ".$code;  
						$header["amount"] = $totals*-1;
						$header["accountType"] ="bank";
						$header["accountNumber"] =$bank;
						$header["user"] =$myUserName;
						array_push($items, $header);
					$response = post($items,"reverseexpresssale", $code);
				}
				else{
					$response['status']=false;
					$response['message']="This sale has no items for reversing";
				}
			}else{
				$response['status']=false;
				$response['message']="This sale has already been reversed";
			}
		}else{
			$response['status']=false;
			$response['message']="This sale has not been posted";
		}
	}else{
		$response['status']=false;
		$response['message']="This sale does not exist";
	}

}
else if($type=="stocktransfer"){
	$code = $_POST['code'];
	$sql = "SELECT A.*, B.name tfrom,C.name tto  FROM `stocktransfers` A LEFT JOIN shopLocations B  ON B.id=A.transferFrom LEFT JOIN shopLocations C  ON C.id=A.transferTo WHERE `posted`=0 AND `code` = '$code' ";
	$res = mysqli_query($conn, $sql);
	if (mysqli_num_rows($res)>0) {
		$mrow = mysqli_fetch_assoc($res);
		$to = $mrow['transferTo'];
		$from = $mrow['transferFrom'];
		$date = $mrow['dateCreated'];
		$toName = $mrow['tto'];
		$fromName = $mrow['tfrom'];
		$items = array();
		$getLines = "SELECT A.*,B.postingGroup FROM `stocktransferlines` A LEFT JOIN items B on A.item = B.code WHERE A.`transferCode` = '$code'";
		$result = mysqli_query($conn, $getLines);
		$emptiesCode = getEmptiesCode();
		$productInfo = fetchWithPdo("SELECT * FROM `items` WHERE code = ?",array($emptiesCode));
	    $emptiesBuyingPrice=isset($productInfo[0]["buying_price"])?$productInfo[0]["buying_price"]:0;
	
		while ($row = mysqli_fetch_assoc($result)) {
		    $postingGroup = $row['postingGroup'];
		    if($from==0){//coming from the free issue
		        $transferTo = array();
			    $transferFrom = array();
			    $transferFrom['documentNo'] = $code;
			    $transferFrom['externalDocumentno'] = "";
			    $transferFrom['transactionDate'] = $date;
			    $transferFrom['item'] = $row['item'];
			    $transferFrom['transactionType'] = "stock_transfer";
			    $transferFrom['accountType'] = "item";
			    $transferFrom['accountNumber'] = $row['item'];
			    $transferFrom['description'] = 'Stock transfer from '.$fromName. ' to '.$toName;
			    $transferFrom['unitPrice'] = $row['unitPrice'];
			    $transferFrom['location'] = $from;
			    $quantity= $row['quantity'];
			    $transferFrom['quantity'] = $quantity*-1;
			    $unitPrice = $row['unitPrice'];
			    $total=$quantity*$unitPrice;
			    $total = $total*-1;
			    $transferFrom['total'] = 0;//$total;
			    $transferFrom['amount'] = 0;//$total;
			    $transferFrom['user'] = $myUserName;
			    
			    $transferTo['documentNo'] = $code;
			    $transferTo['externalDocumentno'] = "";
			    $transferTo['transactionDate'] = $date;
			    $transferTo['item'] = $row['item'];
			    $transferTo['transactionType'] ="stock_transfer";
			    $transferTo['accountType'] = "item";
			    $transferTo['accountNumber'] = $row['item'];
			    $transferTo['description'] = 'Stock transfer from '.$fromName. ' to '.$toName;
			    $transferTo['unitPrice'] = $row['unitPrice'];
			    $transferTo['location'] = $to;
			    $quantity= $row['quantity'];
			    $transferTo['quantity'] = $quantity;
			    $unitPrice = $row['unitPrice'];
			    $total=$quantity*$unitPrice;
			    $total = $total;
			    $transferTo['total'] = $total;
			    $transferTo['amount'] = $total;
			    $transferTo['user'] = $myUserName;
    
			    array_push($items, $transferFrom);
			    
			    /*array_push($items, $transferTo);
			    $freeIssuePayable = array();
			    $freeIssuePayable['documentNo'] = $code;
                $freeIssuePayable['externalDocumentno'] = "";
                $freeIssuePayable['transactionDate'] = $date;
                $freeIssuePayable['item'] = $row['item'];
                $freeIssuePayable['transactionType'] = $row['item'];
                $freeIssuePayable['accountType'] = "vendor";
                $freeIssuePayable['accountNumber'] ="0019";
                $freeIssuePayable['description'] = 'Stock transfer from '.$fromName. ' to '.$toName;
                $freeIssuePayable['unitPrice'] = $row['unitPrice'];
                $freeIssuePayable['location'] = $to;
                $freeIssuePayable['quantity'] = $quantity;
                $freeIssuePayable['total'] = $total*-1;
                $freeIssuePayable['amount'] = $total*-1;
                $freeIssuePayable['user'] = $myUserName;
                array_push($items, $freeIssuePayable);*/
		    }
		    elseif($from==1){//coming from the main warehouse
		        $transferTo = array();
			    $transferFrom = array();
			    $transferFrom['documentNo'] = $code;
			    $transferFrom['externalDocumentno'] = "";
			    $transferFrom['transactionDate'] = $date;
			    $transferFrom['item'] = $row['item'];
			    $transferFrom['transactionType'] = "stock_transfer";
			    $transferFrom['accountType'] = "item";
			    $transferFrom['accountNumber'] = $row['item'];
			    $transferFrom['description'] = 'Stock transfer from '.$fromName. ' to '.$toName;
			    $transferFrom['unitPrice'] = $row['unitPrice'];
			    $transferFrom['location'] = $from;
			    $quantity= $row['quantity'];
			    $transferFrom['quantity'] = $quantity*-1;
			    $unitPrice = $row['unitPrice'];
			    $total=$quantity*$unitPrice;
			    $total = $total*-1;
			    $transferFrom['total'] = $total;
			    $transferFrom['amount'] = $total;
			    $transferFrom['user'] = $myUserName;
			    
			    $transferTo['documentNo'] = $code;
			    $transferTo['externalDocumentno'] = "";
			    $transferTo['transactionDate'] = $date;
			    $transferTo['item'] = $row['item'];
			    $transferTo['transactionType'] ="stock_transfer";
			    $transferTo['accountType'] = "item";
			    $transferTo['accountNumber'] = $row['item'];
			    $transferTo['description'] = 'Stock transfer from '.$fromName. ' to '.$toName;
			    $transferTo['unitPrice'] = $row['unitPrice'];
			    $transferTo['location'] = $to;
			    $quantity= $row['quantity'];
			    $transferTo['quantity'] = $quantity;
			    $unitPrice = $row['unitPrice'];
			    $total=$quantity*$unitPrice;
			    $total = $total;
			    $transferTo['total'] = $total;
			    $transferTo['amount'] =$total;
			    $transferTo['user'] = $myUserName;
    
			    array_push($items, $transferFrom);
			    
			    array_push($items, $transferTo);
			    /*$freeIssuePayable = array();
			    $freeIssuePayable['documentNo'] = $code;
                $freeIssuePayable['externalDocumentno'] = "";
                $freeIssuePayable['transactionDate'] = $date;
                $freeIssuePayable['item'] = $row['item'];
                $freeIssuePayable['transactionType'] = $row['item'];
                $freeIssuePayable['accountType'] = "vendor";
                $freeIssuePayable['accountNumber'] ="0019";
                $freeIssuePayable['description'] = 'Stock transfer from '.$fromName. ' to '.$toName;
                $freeIssuePayable['unitPrice'] = $row['unitPrice'];
                $freeIssuePayable['location'] = $to;
                $freeIssuePayable['quantity'] = $quantity;
                $freeIssuePayable['total'] = $total;
                $freeIssuePayable['amount'] = $total;
                $freeIssuePayable['user'] = $myUserName;
                array_push($items, $freeIssuePayable);*/
		    }
		    else{//coming from the main warehouse
		        $transferTo = array();
			    $transferFrom = array();
			    $transferFrom['documentNo'] = $code;
			    $transferFrom['externalDocumentno'] = "";
			    $transferFrom['transactionDate'] = $date;
			    $transferFrom['item'] = $row['item'];
			    $transferFrom['transactionType'] ="stock_transfer";
			    $transferFrom['accountType'] = "item";
			    $transferFrom['accountNumber'] = $row['item'];
			    $transferFrom['description'] = 'Stock transfer from '.$fromName. ' to '.$toName;
			    $transferFrom['unitPrice'] = $row['unitPrice'];
			    $transferFrom['location'] = $from;
			    $quantity= $row['quantity'];
			    $transferFrom['quantity'] = $quantity*-1;
			    $unitPrice = $row['unitPrice'];
			    $total=$quantity*$unitPrice;
			    $total = $total*-1;
			    $transferFrom['total'] = $total;
			    $transferFrom['amount'] = $total;
			    $transferFrom['user'] = $myUserName;
			    
			    $transferTo['documentNo'] = $code;
			    $transferTo['externalDocumentno'] = "";
			    $transferTo['transactionDate'] = $date;
			    $transferTo['item'] = $row['item'];
			    $transferTo['transactionType'] = "stock_transfer";
			    $transferTo['accountType'] = "item";
			    $transferTo['accountNumber'] = $row['item'];
			    $transferTo['description'] = 'Stock transfer from '.$fromName. ' to '.$toName;
			    $transferTo['unitPrice'] = $row['unitPrice'];
			    $transferTo['location'] = $to;
			    $quantity= $row['quantity'];
			    $transferTo['quantity'] = $quantity;
			    $unitPrice = $row['unitPrice'];
			    $total=$quantity*$unitPrice;
			    $total = $total;
			    $transferTo['total'] = $total;
			    $transferTo['amount'] = $total;
			    $transferTo['user'] = $myUserName;
    
			    array_push($items, $transferFrom);
			    
			    array_push($items, $transferTo);
			
		    }
		    if($postingGroup=="17"){//move the complete empty as well
		        $transferTo = array();
			    $transferFrom = array();
			    $transferFrom['documentNo'] = $code;
			    $transferFrom['externalDocumentno'] = "";
			    $transferFrom['transactionDate'] = $date;
			    $transferFrom['transactionType'] = "stock_transfer";
			    $transferFrom['accountType'] = "item";
			    $transferFrom['accountNumber'] = $emptiesCode;
			    $transferFrom['description'] = 'Empties with Stock transfer from '.$fromName. ' to '.$toName;
			    $transferFrom['location'] = $from;
			    $quantity= $row['quantity'];
			    $transferFrom['quantity'] = $quantity*-1;
			    $unitPrice = $emptiesBuyingPrice;//$row['unitPrice'];
			    $total=$quantity*$unitPrice;
			    $transferFrom['total'] = $total*-1;
			    $transferFrom['amount'] =$total*-1;
			    $transferFrom['user'] = $myUserName;
			    
			    $transferTo['documentNo'] = $code;
			    $transferTo['externalDocumentno'] = "";
			    $transferTo['transactionDate'] = $date;
			    $transferTo['transactionType'] ="stock_transfer";
			    $transferTo['accountType'] = "item";
			    $transferTo['accountNumber'] = $emptiesCode;
			    $transferTo['description'] = 'Empties with Stock transfer from '.$fromName. ' to '.$toName;
			    $transferTo['location'] = $to;
			    $quantity= $row['quantity'];
			    $transferTo['quantity'] = $quantity;
			    $unitPrice =$emptiesBuyingPrice;// $row['unitPrice'];
			    $total=$quantity*$unitPrice;
			    $total = $total;
			    $transferTo['total'] = $total;
			    $transferTo['amount'] = $total;
			    $transferTo['user'] = $myUserName;
    
			    array_push($items, $transferFrom);
			    array_push($items, $transferTo);
		    }
		}
		$response = post($items,"stocktransfer", $code);
	}else{
		$response['status']=false;
		$response['message']="This transfer does not exist or has been posted ";
	}
}
else if($type=="salesheader"){
    //print_r($_POST);
	$docNo = trim($_POST["docNo"]);
	$docType = trim($_POST["docType"]);
	$response = postSalesHeader($docNo,$docType,$myUserName);
}
else if($type=="journal"){
	$journalNo = trim($_POST["journalNo"]);
	$response = postJournal($journalNo,$myUserName);
}
else if($type=="reversejournal"){
	$journalNo = trim($_POST["journalNo"]);
	$tJournalNo = mysqli_real_escape_string($conn, $journalNo);
	$check = "select * from journal where journalNo = '$tJournalNo'";
	$checkRes = mysqli_query($conn,$check);
	while($result = mysqli_fetch_assoc($checkRes)){
		$date = $result["transactionDate"];
		if(!$result["posted"]){
			$response["status"] = false;
			$response["message"] = "The journal has not been posted.";
		}else{
			$getLines = "select * from journallines  where jounalNo ='$tJournalNo'";
			$linesRes = mysqli_query($conn, $getLines);
			$allLines = array();
			while($result = mysqli_fetch_assoc($linesRes)){
				$line = array();
				$line["documentNo"] = $journalNo;
				$line["externalDocumentno"] = $result["externalDocNo"];
				$line["transactionDate"] = $date;
				$line["transactionType"] = $result["transactionType"];
				$line["description"] = "Reverse ".$result["description"];
				$line["amount"] = $result["amount"]*-1;
				$line["accountNumber"] =$result["accountNo"];
				$line["accountType"] = $result["accountType"];
				$line["user"] =$myUserName;
				array_push($allLines, $line);
			}
			$response = post($allLines,"reversejournal", $journalNo);
		}
	}
}
else if ($type == "reverseleaveapplications") {
        $id = trim($_POST["id"]);
        $tLeaveNo = mysqli_real_escape_string($conn, $id);
        $sql = "select A.*,B.*,C.gender employeeGender, (select Sum(NumberOfDays) from leaveledgerentries where Employee = A.employee) leaveBalance from leaveapplications A left join leaveTypes B on A.leaveType = B.no left join employee C on A.employee = C.EmployeeNumber where id = '$tLeaveNo'";
        $res = mysqli_query($conn, $sql);
        while ($result = mysqli_fetch_assoc($res)) {
            $posted = $result["posted"];
            if (!$posted) {
                $response["status"] = false;
                $response["message"] = "The leave application has not been posted";
            } else {
                $annualLeave = $result["annual"];
                if ($annualLeave) {
                    $noOfDays = $result["noOfDays"];
                    //post
                    $employee = $result["employee"];
                    $leaveType = $result["leaveType"];
                    $startDate = $result["startDate"];
                    $returnDate = $result["returnDate"];
                    $description = "Reverse Leave Application $id";
                    $sql = "insert into leaveledgerentries (`Employee`,`documentNumber`,`LeaveType`,`StartDate`,`EndDate`,`description`,`NumberOfDays`,`AddedOn`,`AddedBy`) values (?,?,?,?,?,?,?,NOW(),?)";
                    $values = array($employee, $id, $leaveType, $startDate, $returnDate, $description, $noOfDays, $myUserName);
                    if (pdoExecute($sql, $values)) {
                        $sql = "update leaveapplications set reversed = 1, reversedOn = NOW(), reversedBy= ? where id =?";
                        $values = array($myuserName, $id);
                        if (pdoExecute($sql, $values)) {
                            $response["status"] = true;
                            $response["message"] = "The leave application was successfully reversed";
                        } else {
                            $response["status"] = false;
                            $response["message"] = "The leave application could not be reversed";
                        }
                    } else {
                        $response["status"] = false;
                        $response["message"] = "The leave balances could not be updated";
                    }

                } else {
                    //just mark leave as reversed. No need to adjust ledgers
                    $sql = "update leaveapplications set reversed = 1, reversedOn = NOW(), reversedBy= ? where id =?";
                    $values = array($myUserName, $id);
                    if (pdoExecute($sql, $values)) {
                        $response["status"] = true;
                        $response["message"] = "The leave application was successfully reversed";
                    } else {
                        $response["status"] = false;
                        $response["message"] = "The leave application could not be reversed";
                    }
                }
            }

        }
} 

else if ($type == "leaveapplications") {
  
        $id = trim($_POST["id"]);
        $tLeaveNo = mysqli_real_escape_string($conn, $id);
        $sql = "select A.*,B.*,C.gender employeeGender, (select Sum(NumberOfDays) from leaveledgerentries where Employee = A.employee) leaveBalance from leaveapplications A left join leaveTypes B on A.leaveType = B.no left join employee C on A.employee = C.EmployeeNumber where id = '$tLeaveNo'";
        $res = mysqli_query($conn, $sql);
        //echo $sql;
        while ($result = mysqli_fetch_assoc($res)) {
            $posted = $result["posted"];
            if ($posted) {
                $response["status"] = false;
                $response["message"] = "The leave application has already been posted";
            } else {
                $noOfDays = $result["noOfDays"];
                if ($noOfDays <= 0) {
                    $response["status"] = false;
                    $response["message"] = "No. of days applied must be greater than zero";
                } else {
                    $leaveGender = $result["gender"];
                    $employeeGender = $result["employeeGender"];
                    if (($leaveGender == "Both") || ($leaveGender == $employeeGender)) {
                        //minimum and maximum days
                        $minDays = $result["minDays"];
                        $maxDays = $result["maxDays"];
                        if ($noOfDays < $minDays || $noOfDays > $maxDays) {
                            $response["status"] = false;
                            $response["message"] = "The minimum leave days for the selected leave type is $minDays \n While the maximum is $maxDays . Please apply within this range";
                        } else {
                            $annualLeave = $result["annual"];
                            if ($annualLeave) {
                                $leaveBalance = $result["leaveBalance"];
                                if (false){//$noOfDays > $leaveBalance) {
                                    $response["status"] = false;
                                    $response["message"] = "The employee does not have sufficient leave days";
                                } else {
                                    //post
                                    $employee = $result["employee"];
                                    $leaveType = $result["leaveType"];
                                    $startDate = $result["startDate"];
                                    $returnDate = $result["returnDate"];
                                    $description = "Leave Application $id";
                                    $sql = "insert into leaveledgerentries (`Employee`,`documentNumber`,`LeaveType`,`StartDate`,`EndDate`,`description`,`NumberOfDays`,`AddedOn`,`AddedBy`) values (?,?,?,?,?,?,?,NOW(),?)";
                                    $values = array($employee, $id, $leaveType, $startDate, $returnDate, $description, $noOfDays * -1, $myUserName);
                                    if (pdoExecute($sql, $values)) {
                                        $sql = "update leaveapplications set posted = 1, postedOn = NOW(), postedBy= ? where id =?";
                                        $values = array("", $id);
                                        if (pdoExecute($sql, $values)) {
                                            $response["status"] = true;
                                            $response["message"] = "The leave application was successfully posted";
                                        } else {
                                            $response["status"] = false;
                                            $response["message"] = "The leave application could not be posted";
                                        }
                                    } else {
                                        $response["status"] = false;
                                        $response["message"] = "The leave balances could not be updated";
                                    }
                                }
                            } else {
                                //just mark leave as posted. No need to adjust ledgers
                                $sql = "update leaveapplications set posted = 1, postedOn = NOW(), postedBy= ? where id =?";
                                $values = array($myUserName, $id);
                                if (pdoExecute($sql, $values)) {
                                    $response["status"] = true;
                                    $response["message"] = "The leave application was successfully posted";
                                } else {
                                    $response["status"] = false;
                                    $response["message"] = "The leave application could not be posted";
                                }
                            }
                        }
                    } else {
                        $response["status"] = false;
                        $response["message"] = "The selected leave type does not apply to the employee gender";
                    }
                }
            }
        }

} 
else if ($type == "salaryadvances") {
        $loanNo = trim($_POST["loanNo"]);

        $tLoanNo = mysqli_real_escape_string($conn, $loanNo);
        $sql = "select A.*, B.EmployeeNumber from salaryadvance A left join employee B on A.employee = B.EmployeeNumber where A.id = '$tLoanNo'";
        $res = mysqli_query($conn, $sql);
        //check the loan exists
        if (mysqli_num_rows($res) > 0) {
            while ($result = mysqli_fetch_assoc($res)) {
                //the loan has not been posted
                if ($result["posted"]) {
                    $response["status"] = false;
                    $response["message"] = "The selected salary advance has already been issued";
                } else {
                    $amount = $result["amount"];
                    $employeeNumber = $result["EmployeeNumber"] . "";
                    //amount is not zero or less
                    if ($amount > 0) {
                        //the loan is assigned to an employee
                        if (strlen($employeeNumber) > 0) {
                            //post
                            $employeeName = getAccountName("employee", $employeeNumber);
                            $description = "Salary Advance to $employeeName  Employee Number $employeeNumber";
                            $items = array();
                            $header = array();
                            $header["documentNo"] = $loanNo;
                            $header["externalDocumentno"] = $result["extDocNo"];
                            $header["transactionDate"] = $result["date"];
                            $header["transactionType"] = "6111";
                            $header["description"] = $description;
                            $header["amount"] = $amount;
                            $header["accountType"] = "salaryadvance";
                            $header["accountNumber"] = $loanNo;
                            $header["user"] = $myUserName;

                            array_push($items, $header);
                            //bank entries
                            $line = array();
                            $line["documentNo"] = $loanNo;
                            $line["externalDocumentno"] = $result["extDocNo"];
                            $line["transactionDate"] = $result["date"];
                            $line["transactionType"] = "6111";
                            $line["description"] = $description;
                            $line["amount"] = $amount * -1;
                            $line["accountNumber"] = $result["bank"];
                            $line["accountType"] = "bank";
                            $line["user"] = $myUserName;
                            array_push($items, $line);
                            $response = post($items, "salaryadvance", $loanNo);
                        } else {
                            $response["status"] = false;
                            $response["message"] = "Please select the employee receiving the salary advance";
                        }
                    } else {
                        $response["status"] = false;
                        $response["message"] = "Salary advance must be greater than 0";
                    }
                }
            }
        } else {
            $response["status"] = false;
            $response["message"] = "A Salary Advance with the given number does not exist";
        }


    }

else if ($type == "reversesalaryadvances") {

        $loanNo = trim($_POST["loanNo"]);
        $tLoanNo = mysqli_real_escape_string($conn, $loanNo);
        $sql = "select A.*, B.EmployeeNumber from salaryadvance A left join employee B on A.employee = B.EmployeeNumber where A.id = '$tLoanNo'";
        $res = mysqli_query($conn, $sql);
        //check the loan exists
        if (mysqli_num_rows($res) > 0) {
            while ($result = mysqli_fetch_assoc($res)) {
                //the loan has not been posted
                if (!$result["posted"]) {
                    $response["status"] = false;
                    $response["message"] = "The selected salary advance has not been posted";
                } else {
                    $amount = $result["amount"];
                    $employeeNumber = $result["EmployeeNumber"] . "";
                    //amount is not zero or less
                    //the installments are not zero or less
                    if ($amount > 0) {
                        //the loan is assigned to an employee
                        if (strlen($employeeNumber) > 0) {
                            //post
                            $employeeName = getAccountName("employee", $employeeNumber);
                            $description = "Reversed Salary Advance to $employeeName  Employee Number $employeeNumber";
                            $items = array();
                            $header = array();
                            $header["documentNo"] = $loanNo;
                            $header["externalDocumentno"] = $result["extDocNo"];
                            $header["transactionDate"] = $result["date"];
                            $header["transactionType"] = "5111";
                            $header["description"] = $description;
                            $header["amount"] = $amount * -1;
                            $header["accountType"] = "salaryadvance";
                            $header["accountNumber"] = $loanNo;
                            $header["user"] = $myUserName;

                            array_push($items, $header);
                            //bank entries
                            $line = array();
                            $line["documentNo"] = $loanNo;
                            $line["externalDocumentno"] = $result["extDocNo"];
                            $line["transactionDate"] = $result["date"];
                            $line["transactionType"] = "5111";
                            $line["description"] = $description;
                            $line["amount"] = $amount;
                            $line["accountNumber"] = $result["bank"];
                            $line["accountType"] = "bank";
                            $line["user"] = $myUserName;
                            array_push($items, $line);
                            $response = post($items, "reversesalaryadvance", $loanNo);
                        } else {
                            $response["status"] = false;
                            $response["message"] = "Please select the employee receiving the salary advance";
                        }
                    } else {
                        $response["status"] = false;
                        $response["message"] = "Salary Advance Amount must be greater than 0";
                    }
                }
            }
        } else {
            $response["status"] = false;
            $response["message"] = "A salary advance with the given number does not exist";
        }
}

else if ($type == "staffloan") {

        $loanNo = trim($_POST["loanNo"]);
        $tLoanNo = mysqli_real_escape_string($conn, $loanNo);
        $sql = "select A.*, B.EmployeeNumber from staffloan A left join employee B on A.employee = B.EmployeeNumber where A.id = '$tLoanNo'";
        $res = mysqli_query($conn, $sql);
        //check the loan exists
        if (mysqli_num_rows($res) > 0) {
            while ($result = mysqli_fetch_assoc($res)) {
                //the loan has not been posted
                if ($result["posted"]) {
                    $response["status"] = false;
                    $response["message"] = "The selected staff loan has already been issued";
                } else {
                    $amount = $result["amount"];
                    $installments = $result["installments"];
                    $employeeNumber = $result["EmployeeNumber"] . "";
                    //amount is not zero or less
                    //the installments are not zero or less
                    if (($amount > 0) && ($installments > 0)) {
                        //the loan is assigned to an employee
                        if (strlen($employeeNumber) > 0) {
                            //post
                            $employeeName = getAccountName("employee", $employeeNumber);
                            $description = "Staff loan to $employeeName  Employee Number $employeeNumber";
                            $items = array();
                            $header = array();
                            $header["documentNo"] = $loanNo;
                            $header["externalDocumentno"] = $result["extDocNo"];
                            $header["transactionDate"] = $result["date"];
                            $header["transactionType"] = "5111";
                            $header["description"] = $description;
                            $header["amount"] = $amount;
                            $header["accountType"] = "staffloan";
                            $header["accountNumber"] = $loanNo;
                            $header["user"] = $myUserName;

                            array_push($items, $header);
                            //bank entries
                            $line = array();
                            $line["documentNo"] = $loanNo;
                            $line["externalDocumentno"] = $result["extDocNo"];
                            $line["transactionDate"] = $result["date"];
                            $line["transactionType"] = "5111";
                            $line["description"] = $description;
                            $line["amount"] = $amount * -1;
                            $line["accountNumber"] = $result["bank"];
                            $line["accountType"] = "bank";
                            $line["user"] = $myUserName;
                            array_push($items, $line);
                            $response = post($items, "staffloan", $loanNo);
                        } else {

                            $response["status"] = false;
                            $response["message"] = "Please select the employee receiving the loan";

                        }
                    } else {
                        $response["status"] = false;
                        $response["message"] = "Loan amount and installments must be greater than 0";
                    }
                }
            }
        } else {
            $response["status"] = false;
            $response["message"] = "A staff loan with the given loan number does not exist";
        }
}

else if ($type == "reversestaffloan") {
        $loanNo = trim($_POST["loanNo"]);
        $tLoanNo = mysqli_real_escape_string($conn, $loanNo);
        $sql = "select A.*, B.EmployeeNumber from staffloan A left join employee B on A.employee = B.EmployeeNumber where A.id = '$tLoanNo'";
        $res = mysqli_query($conn, $sql);
        //check the loan exists
        if (mysqli_num_rows($res) > 0) {
            while ($result = mysqli_fetch_assoc($res)) {
                //the loan has not been posted
                if (!$result["posted"]) {
                    $response["status"] = false;
                    $response["message"] = "The selected staff loan has not been posted";
                } else {
                    $amount = $result["amount"];
                    $installments = $result["installments"];
                    $employeeNumber = $result["EmployeeNumber"] . "";
                    //amount is not zero or less
                    //the installments are not zero or less
                    if (($amount > 0) && ($installments > 0)) {
                        //the loan is assigned to an employee
                        if (strlen($employeeNumber) > 0) {
                            //post
                            $employeeName = getAccountName("employee", $employeeNumber);
                            $description = "Reversed Staff loan to $employeeName  Employee Number $employeeNumber";
                            $items = array();
                            $header = array();
                            $header["documentNo"] = $loanNo;
                            $header["externalDocumentno"] = $result["extDocNo"];
                            $header["transactionDate"] = $result["date"];
                            $header["transactionType"] = "5111";
                            $header["description"] = $description;
                            $header["amount"] = $amount * -1;
                            $header["accountType"] = "staffloan";
                            $header["accountNumber"] = $loanNo;
                            $header["user"] = $myUserName;

                            array_push($items, $header);
                            //bank entries
                            $line = array();
                            $line["documentNo"] = $loanNo;
                            $line["externalDocumentno"] = $result["extDocNo"];
                            $line["transactionDate"] = $result["date"];
                            $line["transactionType"] = "5111";
                            $line["description"] = $description;
                            $line["amount"] = $amount;
                            $line["accountNumber"] = $result["bank"];
                            $line["accountType"] = "bank";
                            $line["user"] = $myUserName;
                            array_push($items, $line);
                            $response = post($items, "reversestaffloan", $loanNo);
                        } else {
                            $response["status"] = false;
                            $response["message"] = "Please select the employee receiving the loan";
                        }
                    } else {
                        $response["status"] = false;
                        $response["message"] = "Loan amount and installments must be greater than 0";
                    }
                }
            }
        } else {
            $response["status"] = false;
            $response["message"] = "A staff loan with the given loan number does not exist";
        }

}
else if($type=="customerinvoice"){
	if(isset($_POST["invoiceNo"])){
	$invoiceNo = mysqli_real_escape_string($conn, trim($_POST["invoiceNo"]));
	$sql = "SELECT A.*,B.*,C.*,(SELECT Sum(totalAmount) FROM `customerinvoicelines` where invoiceNo = A.invoiceNo) totalAmount,NOW() currentTime FROM `customerinvoices` A left join customers B on A.customer = B.customerNumber left join postinggroups C on B.customerpostinggroup = C.id  where A.invoiceNo ='$invoiceNo' and A.posted=0";
	$res = mysqli_query($conn, $sql);
	$salesRep = "";
	$region = "";
	while($result = mysqli_fetch_assoc($res)){
		$error = false;
		$invoiceDate = "";
		$message = "";
		//region`, `sales_rep 
		$salesRep = $result["sales_rep"];
	    $region = $result["region"];
		//check customer has been selected
		$customer = $result["customer"];
		$shopLocationCode = $result["shopLocationCode"]+0;
		$customerNumber = $result["customerNumber"];
		$invoiceDate = $result["invoiceDate"];
		if($customerNumber==""){
			$error = true;
			$message.=strlen($message)>0?"\n":"";
			$message.="The invoice does not have a customer. Please select";
		}
		$customerPostingGroup = $result["id"];
		if(!is_numeric($customerPostingGroup)||$customerPostingGroup<1){
			$error = true;
			$message.=strlen($message)>0?"\n":"";
			$message.="The selected customer does not have a customer posting group. Please update the customer before posting.";
		}
		
		//check posting group has a g/l account
		$glaccount = $result["glaccount"];
		if($glaccount==""){
			$error = true;
			$message.=strlen($message)>0?"\n":"";
			$message.="The customer's posting group does not have a G/L Account. Please update";
		}
		//check invoice total is greater than 0
		
		$totalAmount = $result["totalAmount"];
		if($totalAmount<0){
			$error = true;
			$message.=strlen($message)>0?"\n":"";
			$message.="The invoice total amount is less than zero. Kindly add invoice lines";
		}
		if($error){
			$response["status"] = false;
			$response["message"] =$message;
		}else{
				$items = array();
				$header = array();
				$header["documentNo"] = $invoiceNo;
				$header["externalDocumentno"] = "";
				$header["transactionDate"] = $invoiceDate;
				$header["transactionType"] = "602";
				$header["description"] = "Customer Invoice $invoiceNo";
				$header["amount"] = $totalAmount;				
				$header["accountType"] ="customer";
				$header["accountNumber"] =$customerNumber;
				$header["region"] =$region;
				$header["salesRep"] =$salesRep;
				$header["user"] =$myUserName;
				array_push($items, $header);
				// 
				// 
				$getLines = "SELECT A.*,B.*,A.description customDesc FROM `customerinvoicelines` A left join chargeitems B on A.itemNo = B.id where invoiceNo = '$invoiceNo' and itemType = 'Charge Items'";
				$linesRes = mysqli_query($conn,$getLines);
				while($lineResult = mysqli_fetch_assoc($linesRes)){
					$line = array();
					$line["documentNo"] = $invoiceNo;
					$line["externalDocumentno"] = "";
					$line["transactionDate"] = $invoiceDate;
					$line["transactionType"] = "602";
					$line["description"] = $lineResult["customDesc"];  
					$line["amount"] = $lineResult["totalAmount"]*-1;
					$line["accountType"] ="glaccount";
					$line["accountNumber"] =$lineResult["account_no"];
					$line["user"] =$myUserName;
					$line["region"] =$region;
				    $line["salesRep"] =$salesRep;
					array_push($items, $line);					
				}
				$getLines = "SELECT A.*,B.*, A.description lineDescription,C.quantity relationshipQuantity FROM `customerinvoicelines` A left join items B on A.itemNo = B.code left join unitofmeasurerelationships C on A.unitOfMeasureCode = C.id where invoiceNo = '$invoiceNo' and itemType = 'Items' ";
				
				$linesRes = mysqli_query($conn,$getLines);
				while($lineResult = mysqli_fetch_assoc($linesRes)){
					$line = array();
					$line["documentNo"] = $invoiceNo;
					$line["externalDocumentno"] = "";
					$line["transactionDate"] = $invoiceDate;
					$line["transactionType"] = "20002";
					$line["description"] = $lineResult["lineDescription"];  
					$relationshipQuantity=$lineResult["relationshipQuantity"]+0;
					$invoiceQuantity =  $lineResult["quantity"];
					$realQuantity = 0;
					if($relationshipQuantity<>0){
					    $realQuantity=$relationshipQuantity*$invoiceQuantity;
					}else{
					    $realQuantity=$invoiceQuantity;
					}
					$line["quantity"] =$realQuantity*-1;  
					$line["amount"] = $lineResult["totalAmount"]*-1;
					$line["accountType"] ="item";
					$line["accountNumber"] =$lineResult["code"];
					$line["region"] =$region;
				    $line["salesRep"] =$salesRep;
					$line["location"] =$shopLocationCode;
					$line["user"] =$myUserName;
					array_push($items, $line);	
				if($shopLocationCode<1){
					$error = true;
					$message.=strlen($message)>0?"\n":"";
					$message.="Please select the shop location";
				}				
				}
				if($error){
					$response["status"] = false;
					$response["message"] =$message;
				}else{					
					$response = post($items,"customerinvoice", $invoiceNo);
				}
		}
	}
}

}
else if($type=="receipt"){
	if(isset($_POST["receiptNo"])){
		$receiptNo = mysqli_real_escape_string($conn, trim($_POST["receiptNo"]));
		//validate
		$getReceipt = "SELECT A.*, (SELECT Sum(Amount)  FROM `receiptline` where ReceiptNo = '$receiptNo') total, (SELECT RequiresRef FROM `paymentmethods` where Id = A.PaymentMethod) requiresRef FROM `receiptheader` A WHERE ReceiptNo = '$receiptNo' and Posted=0";
		$receiptRes = mysqli_query($conn, $getReceipt);
		if(mysqli_num_rows($receiptRes)<1){
				$response["status"] = false;
				$response["message"] ="The receipt does not exist or has already been posted";
		}
		$error = false;
		$message = "";
		while($receipt = mysqli_fetch_assoc($receiptRes)){
			$member = $receipt["Member"];
			$paymentMethod = $receipt["PaymentMethod"];
			$bank = $receipt["Bank"];
			$externalRef = $receipt["ExternalRefNo"];
			$payDate = $receipt["PaymentDate"];
			$receivedFrom = $receipt["ReceivedFrom"];
			$receiptTotal = $receipt["total"];
			$requiresRef = $receipt["requiresRef"];
			if($member==""){
				$message = "Please select member";
				$error = true;			}
			if(!$paymentMethod>0){
				$message.= strlen($message)>0?"\n":"";
				$message .= "Please select a valid payment method";
				$error = true;
			}
			if(!$bank>0){
				$message.= strlen($message)>0?"\n":"";
				$message .= "Please select the bank receiving the payment";
				$error = true;
			}
			if($requiresRef){
				if($externalRef==""){
				$message.= strlen($message)>0?"\n":"";
				$message .= "Please enter the payment ref/ external document number";
				$error = true;	
				}
			}
			if($payDate==""){
					$message.= strlen($message)>0?"\n":"";
				$message .= "Please enter the payment date";
				$error = true;	
			}
			if($receivedFrom==""){
					$message.= strlen($message)>0?"\n":"";
				$message .= "Please enter the name of the person from whom the payment is received";
				$error = true;	
			}
			if(!$receiptTotal>0){
				$message.= strlen($message)>0?"\n":"";
				$message .= "The receipt appears blank. The total is zero";
				$error = true;	
			}
			if($error){
				$response["status"] = false;
				$response["message"] =$message;
			}else{
				
				
				//post receipt
				$items = array();
				$header = array();
				$header["documentNo"] = $receiptNo;
				$header["externalDocumentno"] = $externalRef;
				$header["transactionDate"] = $payDate;
				$header["transactionType"] = "601";
				$memberName = getMemberName($member);
				$header["description"] = "$memberName Receipt $receiptNo";
				$header["amount"] = $receiptTotal;
				$header["accountType"] = "bank";				
				$header["accountNumber"] =$bank;
				$header["user"] = $myUserName;
				
				
				
				array_push($items, $header);
				$getLines = "SELECT A.*, B.Description transType, B.GLAccount transGlAccount, B.journalAccountType FROM `receiptline` A left join transactiontypes B on A.TransactionType = B.Code where ReceiptNo = '$receiptNo'";
				$linesRes = mysqli_query($conn, $getLines);
				while($line = mysqli_fetch_assoc($linesRes)){
				$receiptLine = array();
				$receiptLine["documentNo"] = $receiptNo;
				$receiptLine["externalDocumentno"] = $externalRef;
				$receiptLine["transactionDate"] = $payDate;
				$receiptLine["transactionType"] = $line["TransactionType"];
				$journalAccountType = $line["journalAccountType"];
				$receiptLine["description"] = $line["transType"]." from receipt $receiptNo $memberName";
				$receiptLine["amount"] = $line["Amount"]*-1;	
				//'','vehicle',''
				if($journalAccountType=="member"){
					$receiptLine["accountType"] ="member";				
					$receiptLine["accountNumber"] = $member;
				}else if($journalAccountType=="vehicle"){
					$receiptLine["accountType"] ="vehicle";				
					$receiptLine["accountNumber"] = $line["vehicle"];
				}else if($journalAccountType=="loan"){
					$receiptLine["accountType"] ="loan";				
					$receiptLine["accountNumber"] = $line["LoanNo"];
				}else{
					$receiptLine["accountType"] ="glaccount";				
					$receiptLine["accountNumber"] = $line["transGlAccount"];
				}		
								
				$receiptLine["user"] = $myUserName;
				array_push($items, $receiptLine);
				}
				//add the lines
				
				
				$response = post($items,"receipt", $receiptNo);
				
				
			}
		
		}
	}
	
}
else if($type=="superuserapproval"){
	$docNo = trim($_POST["docNo"]);
	$docType = trim($_POST["docType"]);
	$getDocument = fetchWithPdo("SELECT * FROM `sales_header` WHERE doc_no = ? and document_type = ?",array($docNo,$docType));
	if(count($getDocument)==1){
		$document = $getDocument[0];
		$status = $document["status"];
		if($status=="Approved"){
			//make sure is approved
			//make sure super user hasn't approved
			if($document["confirmed_by_super_user"]){
				$response["status"] = false;
				$response["message"] ="The super user has already approved";
			}else{
				$sql = "UPDATE `sales_header` SET `confirmed_by_super_user`=?,`super_user`=?,`super_user_approved_on`=NOW() WHERE `doc_no`=? and `document_type`=?";
				$values = array(1,$myUserName,$docNo,$docType);
				if(pdoExecute($sql,$values)){
					$response["status"] = true;
					$response["message"] = "The record was successfully approved";
				}else{
					$response["status"] = false;
					$response["message"] = "The record could not be approved";
				}
			}
			//mark super user approved
		}else{
			$response["status"] = false;
			$response["message"] ="The document has not been approved";
		}
	}else{
		$response["status"] = false;
		$response["message"] ="The document could not be found";
	}
}
else if($type=="accountapprove"){
	$docNo = trim($_POST["docNo"]);
	$docType = trim($_POST["docType"]);
	$getDocument = fetchWithPdo("SELECT A.*,B.receivables_acccount,B.default_bank FROM `sales_header` A LEFT JOIN users B on A.createdBy = B.username WHERE doc_no = ? and document_type = ?",array($docNo,$docType));
	if(count($getDocument)==1){
		$document = $getDocument[0];
		$status = $document["status"];
		if($status=="Approved"){
			if(!$document["confirmed_by_super_user"]){
				$response["status"] = false;
				$response["message"] ="The super user has not yet approved";
			}else{
				if($document["confirmed_by_accounts"]){
						$response["status"] = false;
						$response["message"] ="The document has already been posted";
				}else{
					$payments = fetchWithPdo("SELECT A.*,B.PaymentMethod payMethodDescription FROM `daily_report_payments` A LEFT JOIN paymentmethods B on A.payment_method= B.Id WHERE  A.confirmed_amount <>0 and A.report_id=? ",array($docNo));
					if(count($payments)>0){
						$salesDate = $document["sales_date"];
						$vsmReceivablesAccount =  $document["receivables_acccount"];
						$defaultBank =  $document["default_bank"];
						$items=array();
						$error = false;
						$message = "";
						foreach($payments as $payment){
							$header = array();
    						$header["documentNo"] = $docNo;
    						$header["externalDocumentno"] = "";
    						$header["transactionDate"] = $salesDate;
    						$header["transactionType"] = "eod";
    						$header["description"] = $payment["payMethodDescription"];
    						$header["amount"] = $payment["confirmed_amount"]*-1;				
    						$header["user"] =$myUserName;
							$header["accountType"] ="customer";
    						$header["accountNumber"] =$vsmReceivablesAccount;
    						

							$line = array();
    						$line["documentNo"] = $docNo;
    						$line["externalDocumentno"] = "";
    						$line["transactionDate"] = $salesDate;
    						$line["transactionType"] = "eod";
    						$line["description"] = $payment["payMethodDescription"];
    						$line["amount"] = $payment["confirmed_amount"];				
    						$line["user"] =$myUserName;
    						

							$paymentMethod = $payment["payment_method"];
							$skip=false;
							if($paymentMethod==2){//mpesa
								$line["accountType"] ="bank";
    							$line["accountNumber"] =$defaultBank;
							}else if($paymentMethod==4){//on account
							    $skip = true;
								$line["accountType"] ="customer";
    							$line["accountNumber"] = $payment["customer_code"];
							}else if($paymentMethod==5){//cheque
								$line["accountType"] ="customer";
    							$line["accountNumber"] =$payment["customer_code"];
							}else if($paymentMethod==6){//swipe/pdq
								$line["accountType"] ="bank";
    							$line["accountNumber"] =$payment["customer_code"];//"2";
							}else if($paymentMethod==7){//direct transfer
								$line["accountType"] ="bank";
    							$line["accountNumber"] =$payment["customer_code"];//"3";
							}else if($paymentMethod==8){//free issues
								//$line["accountType"] ="customer";
    							//$line["accountNumber"] =$vsmReceivablesAccount;
                                $transferFrom = array();
                                $transferFrom['documentNo'] = $docNo;
                                $transferFrom['externalDocumentno'] = "";
                                $transferFrom['transactionDate'] = $salesDate;
                                $transferFrom['transactionType'] = "eod";
                                $transferFrom['accountType'] = "item";
                                $transferFrom['accountNumber'] = $payment['product_code'];
                                $transferFrom['description'] = "Approved Free Issues transferred to main warehouse";
                                $transferFrom['location'] = 0;
                                $transferFrom['quantity'] = $payment['quantity']*-1;
                                $transferFrom['amount'] = 0;
                                $transferFrom['user'] = $myUserName;
                                array_push($items, $transferFrom);

                                $line['description'] = "Approved Free Issues transferred to main warehouse";
                                $line['location'] = 1;
                                $line['quantity'] = $payment['quantity'];
                                $line["accountType"] ="item";
                                $line["accountNumber"] =getNonFreeVersionCode($payment['product_code']);
    							

    							
							}else if($paymentMethod==9){//credit notes
								$line["accountType"] ="vendor";
    							$line["accountNumber"] ="0002";
							}else if($paymentMethod==10){//discount customers
								$line["accountType"] ="glaccount";//"customer";
    							$line["accountNumber"] = "KSJ014";//$payment["customer_code"];
							}else{
								$error = true;
								$message = "The payment method {$payment["payMethodDescription"]} has not been set up ";
							}
							if(!$skip){
							    array_push($items, $header);
    						    array_push($items, $line);
							}
						}
						if($error){
							$response["status"] = false;
							$response["message"] =$message;
						}else{
							$response = post($items,"endofday", $docNo);
						}
					}else{
						$response["status"] = false;
						$response["message"] ="No payments found for the selected document";
					}
				}
				
			}
		}else{
			$response["status"] = false;
			$response["message"] ="The document has not been approved";
		}
	}else{
		$response["status"] = false;
		$response["message"] ="The document could not be found";
	}
}

else if($type=="servicecharge"){
	if(isset($_POST["voucherNo"])){
	$voucherNo = mysqli_real_escape_string($conn, trim($_POST["voucherNo"]));
	$error = false;
	$message = "";
	//check exists
	//total not zero
	$check = "SELECT *, (SELECT SUM(feeCharged) FROM `service_fee_lines` where voucherNo ='$voucherNo' ) totalLines FROM `service_fee_vouchers` where id ='$voucherNo' and posted =0";
	$res = mysqli_query($conn, $check);
	$exists = false;
	$total = 0;
	$date = "";
	$description = "";
	/*$getDate = "select NOW() as currDate";
	$dateRes = mysqli_query($conn, $getDate);
	while($myDate = mysqli_fetch_assoc($dateRes)){
		$date = $myDate["currDate"];
	}*/
	while($result = mysqli_fetch_assoc($res)){
		$exists = true;
		$total = $result["totalLines"];
		$month = $result["month"];
		$year = $result["year"];		
		$description = "Service Fee for the Period ".getMonthName($month). " " .$year;
		//$"2018-08-24 00:00:00"
		$maxDay  = 30;
			$oddMonths = array(1,3,5,7,8,10,12);
			if(in_array($month,$oddMonths)){
				$maxDay = "31";
			}
			if($month==2){
				$maxDay  = 28;
				if(($year%4)==0){
					$maxDay  = 29;
				}
			}
		$date = $year."-".$month."-".$maxDay." 00:00:00";
	}
	if(!$exists){
		$error = true;
		$message = "A service fee voucher with the given id does not exist";
	}
	if($total<1){
		$error = true;
		$message .=  strlen($message)>1?"\n":"";
		$message .= "A service fee voucher with the given id does not exist";
	}
	if($error){
		$response["status"] = false;
		$response["message"] =$message;
	}else{//post
	
				$items = array();
				$header = array();
				$header["documentNo"] = $voucherNo;
				$header["externalDocumentno"] = "";
				$header["transactionDate"] = $date;
				$header["transactionType"] = "503";
				$header["description"] = $description;
				$header["amount"] = $total*-1;
				$header["accountType"] ="glaccount";
				$header["accountNumber"] ="009";
				$header["user"] = $myUserName;
				
				array_push($items, $header);
				$linesSql = "SELECT * FROM `service_fee_lines` where voucherNo ='$voucherNo' ";
				$getLines = mysqli_query($conn, $linesSql);
				while($myLine = mysqli_fetch_assoc($getLines)){
					$line = array();
					$line["documentNo"] = $voucherNo;
					$line["externalDocumentno"] = "";
					$line["transactionDate"] = $date;
					$line["transactionType"] = "503";
					$line["description"] = $description;
					$line["amount"] = $myLine["feeCharged"];
					$line["accountType"] ="vehicle";
					$line["accountNumber"] =$myLine["vehicle"];					
					$line["user"] = $myUserName;
					array_push($items, $line);
				}
				$response = post($items,"servicefee", $voucherNo);
				
				
		
	}
}


}
else if($type=="stock_conversion"){
    $code = trim($_POST["code"]);
    //check exists
    $check = fetchWithPdo("SELECT * FROM `stock_conversion` WHERE `code`=?",array($code));
    if(count($check)==1){
         $record = $check[0];
        //not posted
        if($record["posted"]){
            $response["status"] = false;
		    $response["message"] ="The selected record has already been posted. No changes can be made";
        }else{
            //source location has enough stock
            $avaialableStock = getStockAtLocation($record["source_product"],$record["source_warehouse"]);
            if(false){//$record["quantity"]>$avaialableStock){
                $response["status"] = false;
		        $response["message"] ="The selected warehouse does not have enough stock.\nAvailable ".number_format($avaialableStock,2);
            }else{
                $items = array();
            
                $line = array();
                $line["documentNo"] = $code;
                $line["externalDocumentno"] = "";
                $line["transactionDate"] = $record["conversion_date"];
                $line["transactionType"] = "stock_conversion";
                $line["description"] = "Stock Conversion";  
                $line["quantity"] =$record["quantity"]*-1;  
                $line["amount"] = $record["value"]>0?0:$record["value"];
                $line["accountType"] ="item";
                $line["accountNumber"] =$record["source_product"];
                $line["region"] ="";
                $line["salesRep"] ="";
                $line["location"] =$record["source_warehouse"];
                $line["user"] =$myUserName;
                array_push($items, $line);
                
                $line = array();
                $line["documentNo"] = $code;
                $line["externalDocumentno"] = "";
                $line["transactionDate"] = $record["conversion_date"];
                $line["transactionType"] = "stock_conversion";
                $line["description"] = "Stock Conversion";  
                $line["quantity"] =$record["quantity"];  
                $line["amount"] = $record["value"]>0?$record["value"]:0;
                $line["accountType"] ="item";
                $line["accountNumber"] =$record["converted_product"];
                $line["region"] ="";
                $line["salesRep"] ="";
                $line["location"] =$record["destination_warehouse"];
                $line["user"] =$myUserName;
                array_push($items, $line);
                
                $line = array();
                $line["documentNo"] = $code;
                $line["externalDocumentno"] = "";
                $line["transactionDate"] = $record["conversion_date"];
                $line["transactionType"] = "stock_conversion";
                $line["description"] = "Conversion of ".$record["quantity"]." ".getAccountName("item",$record["source_product"]);  
                //$multiplier=$record["value"]>0?-1:1;
                $line["amount"] = $record["value"]*-1;//*$multiplier;
                $line["accountType"] ="glaccount";
                $line["accountNumber"] ="KSJ089";
                $line["region"] ="";
                $line["salesRep"] ="";
                $line["user"] =$myUserName;
                array_push($items, $line);
                
                //print_r($items);
                $response = post($items,"stock_conversion", $code);
                
                
            }
        }
        
    }else{
        $response["status"] = false;
		$response["message"] ="A record with the given code could not be found";
    }
}
else if($type=="stock_take"){
    $docNo = trim($_POST["docNo"]);
    $checkClosed = fetchWithPdo("SELECT * FROM `stock_take` WHERE doc_no = ? ",array($docNo));
    if(count($checkClosed)==1){
        if($checkClosed[0]["closed"]){
            $response["status"] = false;
		    $response["message"] ="The stock take has already been closed";
        }else{
            $close = "UPDATE `stock_take` SET `closed`=?, `closed_by`=?, `closed_on`=NOW() WHERE `doc_no`=? limit 1";
            if(pdoExecute($close,array(1,$myUserName,$docNo))){
                $response["status"] = true;
		        $response["message"] ="The stock take was successfully closed"; 
            }else{
               $response["status"] = false;
		       $response["message"] ="The stock take could not be closed"; 
            }
        }
    }else{
        $response["status"] = false;
		$response["message"] ="The stock take could not be found";
    }
}

echo json_encode($response);